/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.io;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;

public class WsApiExecutor {
    private static final Object[] NO_ARGS = new Object[0];
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private Object[] args = NO_ARGS;
    private PathParamReader path;
    private String action;

    public WsApiExecutor(String action, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.response = response;
        this.request = request;
        this.path = new PathParamReader(request);
        this.action = action;
    }

    public WsApiExecutor(String action, HttpServletRequest req, HttpServletResponse resp, Class<?> ... pathTypes) throws IOException {
        this(action, req, resp);
        this.args = new Object[pathTypes.length];
        int index = 0;
        while (index < pathTypes.length) {
            String segment = this.path.getPathSegment(index);
            Class<?> expected = pathTypes[index];
            try {
                if (segment.isEmpty()) {
                    this.args[index] = null;
                } else if (expected == Integer.class) {
                    this.args[index] = Integer.valueOf(this.path.getPathSegment(index));
                } else if (expected == Long.class) {
                    this.args[index] = Long.valueOf(this.path.getPathSegment(index));
                } else if (expected == String.class) {
                    this.args[index] = this.path.getPathSegment(index);
                } else {
                    this.abort(new UnsupportedOperationException(String.valueOf(expected) + " on argument " + index), req.getRemoteUser());
                }
            }
            catch (NumberFormatException nbe) {
                this.abort(new IllegalArgumentException(String.valueOf(expected) + " on argument " + index), req.getRemoteUser());
            }
            ++index;
        }
    }

    void abort(RuntimeException fail, String remoteUser) throws IOException {
        ErrorResponse result = ResponseFactory.createBadRequestErrorResponse(this.getErrorMessage(), fail.getMessage());
        this.response.setStatus(result.getStatus());
        JsonBodyWriter.write(this.response, result.getClass(), result, remoteUser, "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.others");
        throw fail;
    }

    public int getPathSize() {
        return this.path.getPathSize();
    }

    public void setAction(String text) {
        this.action = text;
    }

    public String getSegment(int index) {
        return index < this.getPathSize() ? this.path.getPathSegment(index) : null;
    }

    private String getErrorMessage() {
        return this.getActionMessage() + " failed.";
    }

    public String getActionMessage() {
        return String.format(this.action, this.args);
    }

    public void perform(UnsafeFunction<Object[], AbstractResponse> exe) throws IOException {
        this.doPerform(null, (arguments, useless) -> (AbstractResponse)exe.apply((Object[])arguments));
    }

    public <I> void perform(Class<I> bodyType, BiUnsafeFunction<Object[], I, AbstractResponse> exe) throws IOException {
        this.doPerform(JsonBodyReader.read((ServletRequest)this.request, bodyType), exe);
    }

    private <I> void doPerform(I body, BiUnsafeFunction<Object[], I, AbstractResponse> exe) throws IOException {
        AbstractResponse result;
        try {
            result = exe.apply(this.args, body);
        }
        catch (IllegalArgumentException fail) {
            result = ResponseFactory.createBadRequestErrorResponse(this.getErrorMessage(), fail.getMessage());
        }
        catch (NoSuchElementException | CDOResourceNodeNotFoundException fail) {
            result = ResponseFactory.createNotFoundErrorResponse(this.getErrorMessage(), fail.getMessage());
        }
        catch (UnsupportedOperationException fail) {
            result = ResponseFactory.createErrorResponse(this.getErrorMessage(), 501, fail.getMessage());
        }
        catch (Exception fail) {
            result = ResponseFactory.createInternalServerErrorResponse(this.getErrorMessage(), fail.getMessage());
        }
        if (result.getMessage() == null || result.getMessage().isEmpty()) {
            result.setMessage(this.getActionMessage());
        }
        this.response.setStatus(result.getStatus());
        JsonBodyWriter.write(this.response, result.getClass(), result, this.request.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo");
    }

    public static interface BiUnsafeFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    public static interface UnsafeFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

