/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.module.AdminServletRegistryListener;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.RepositoryManagerRegistryListener;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.JettyServerUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.io.File;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.connector.IServerConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.slf4j.LoggerFactory;

public class AdminServerAppExtension
implements IAppExtension {
    private static final String OPEN_SESSION_LOG_MESSAGE = "Open '{}' - {}";
    private static final String CLOSE_SESSION_LOG_MESSAGE = "Closed '{}'";
    private static final String COMMIT_LOG_LOG_MESSAGE = "Commit on '{}' by '{}' - commit '{}' - '{}'";
    private RepositoryManagerRegistryListener repositoryRegistryListener;
    private AdminServletRegistryListener odServletRegistryModule;

    public void start(File configFile) throws Exception {
        if (this.repositoryRegistryListener == null) {
            this.repositoryRegistryListener = new RepositoryManagerRegistryListener();
        }
        if (this.odServletRegistryModule == null) {
            this.odServletRegistryModule = new AdminServletRegistryListener();
        }
        this.addSessionEventsLogger();
        AdminServerConfigurationHelper adminServerConfigurationHelper = AdminServerConfigurationHelper.getInstance();
        if (adminServerConfigurationHelper.haveToStartAdminServer()) {
            IStatus startHandledRepositories;
            String configFileFolderPath = adminServerConfigurationHelper.getRepositoriesDirectoryPath();
            OM.Activator.getDefault().initRepositoriesConfigFolder(configFileFolderPath);
            String repositoriesExportFolderPath = adminServerConfigurationHelper.getRepositoriesExportDirectoryPath();
            OM.Activator.getDefault().initRepositoriesExportFolder(repositoriesExportFolderPath);
            JVMUtil.prepareContainer((IManagedContainer)OM.Activator.getContainer());
            JVMUtil.getAcceptor((IManagedContainer)OM.Activator.getContainer(), (String)"default");
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.addListener((IRegistryEventListener)this.repositoryRegistryListener, "fr.obeo.dsl.viewpoint.collab.server.admin.repositoryManagerExtension");
            this.repositoryRegistryListener.parseInitialContributions();
            if (adminServerConfigurationHelper.haveToStartJetty()) {
                JettyServerUtil.startJettyServer(OM.Activator.getBundleContext());
                OM.Activator.getDefault().setJettyStarted(true);
                OM.LOG.info("REST Admin - Jetty server started.");
                if (adminServerConfigurationHelper.isAdminFromServletsEnabled()) {
                    registry.addListener((IRegistryEventListener)this.odServletRegistryModule, "fr.obeo.dsl.viewpoint.collab.server.admin.servletExtension");
                    this.odServletRegistryModule.parseInitialContributions();
                    JettyServerUtil.registerRestAdminServlets(OM.Activator.getBundleContext());
                    OM.LOG.info("REST Admin - Admin servlets started.");
                }
                if (adminServerConfigurationHelper.isNet4JWebsocketTransportEnabled()) {
                    JettyServerUtil.registerWebSocketTransport(OM.Activator.getBundleContext());
                    OM.LOG.info("REST Admin - Net4j Websocket transport started.");
                }
            }
            if (!(startHandledRepositories = CDORepositoryUtil.startHandledRepositories()).isOK()) {
                OM.LOG.error(startHandledRepositories.toString(), startHandledRepositories.getException());
            }
            OM.Activator.getDefault().setAdministrationServerStarted(true);
            OM.LOG.info("REST Admin - Administration server started.");
        }
    }

    private void addSessionEventsLogger() {
        Object[] elements;
        OM.Activator.getContainer().addListener((IListener)new ContainerEventAdapter<Object>(true){

            protected void onAdded(IContainer<Object> container, Object element) {
                if (element instanceof InternalRepository) {
                    InternalRepository repository = (InternalRepository)element;
                    AdminServerAppExtension.this.addSessionEventsLogger(repository);
                }
            }
        });
        Object[] objectArray = elements = OM.Activator.getContainer().getElements("org.eclipse.emf.cdo.server.repositories", "default");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof InternalRepository) {
                InternalRepository repository = (InternalRepository)element;
                this.addSessionEventsLogger(repository);
            }
            ++n2;
        }
    }

    private void addSessionEventsLogger(final InternalRepository repository) {
        repository.getSessionManager().addListener((IListener)new ContainerEventAdapter<Session>(){

            protected void onAdded(IContainer<Session> container, Session element) {
                CDOServerProtocol protocol;
                IChannelMultiplexer iChannelMultiplexer;
                String sessionLabel = element.toString();
                String acceptor = "Unknown Acceptor";
                ISessionProtocol iSessionProtocol = element.getProtocol();
                if (iSessionProtocol instanceof CDOServerProtocol && (iChannelMultiplexer = (protocol = (CDOServerProtocol)iSessionProtocol).getChannel().getMultiplexer()) instanceof IServerConnector) {
                    IServerConnector isc = (IServerConnector)iChannelMultiplexer;
                    acceptor = isc.getAcceptor().toString();
                }
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.net4j.session").info(AdminServerAppExtension.OPEN_SESSION_LOG_MESSAGE, (Object)sessionLabel, (Object)acceptor);
            }

            protected void onRemoved(IContainer<Session> container, Session element) {
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.net4j.session").info(AdminServerAppExtension.CLOSE_SESSION_LOG_MESSAGE, (Object)element.toString());
            }
        });
        repository.getCommitInfoManager().addCommitInfoHandler(new CDOCommitInfoHandler(){

            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                Object comment = commitInfo.getComment();
                if (StringUtil.isEmpty((String)comment)) {
                    comment = "Empty commit message";
                } else {
                    int newLine;
                    if (((String)(comment = ((String)comment).trim())).length() > 30) {
                        comment = ((String)comment).substring(0, 30) + "[...]";
                    }
                    if ((newLine = ((String)comment).indexOf(10)) != -1) {
                        comment = ((String)comment).substring(0, newLine) + "[...]";
                    }
                }
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.net4j.commit").info(AdminServerAppExtension.COMMIT_LOG_LOG_MESSAGE, new Object[]{repository.getName(), commitInfo.getUserID(), commitInfo.getTimeStamp(), comment});
            }
        });
    }

    public void stop() throws Exception {
        if (OM.Activator.getDefault().isAdministrationServerStarted()) {
            CDORepositoryUtil.stopHandledRepositories();
            OM.Activator.getDefault().setAdministrationServerStarted(false);
            OM.LOG.info("REST Admin - Administration server stopped.");
        }
        if (OM.Activator.getDefault().isJettyStarted()) {
            JettyServerUtil.stopJettyServer();
            OM.Activator.getDefault().setJettyStarted(false);
            OM.LOG.info("REST Admin - Jetty server stopped.");
        }
        this.disposePluginRegistries();
    }

    private void disposePluginRegistries() {
        if (this.repositoryRegistryListener != null) {
            this.repositoryRegistryListener.dispose();
            this.repositoryRegistryListener = null;
        }
        if (this.odServletRegistryModule != null) {
            this.odServletRegistryModule.dispose();
            this.odServletRegistryModule = null;
        }
    }
}

