/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.DefaultRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.IRepositoryManagerDescriptor;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.RepositoryManagerDescriptorRegistry;
import org.eclipse.emf.cdo.server.IRepository;

public final class RepositoryManagerService {
    private RepositoryManagerService() {
    }

    public static RepositoryManagerService getInstance() {
        return RepositoryManagerServiceHolder.INSTANCE;
    }

    public IRepositoryManager getRepositoryManager(String key) {
        IRepositoryManager result = null;
        IRepositoryManagerDescriptor repositoryManagerDescriptor = RepositoryManagerDescriptorRegistry.getDescriptorFromKey(key);
        if (repositoryManagerDescriptor != null) {
            result = repositoryManagerDescriptor.getRepositoryManager();
        }
        if (result == null) {
            result = new DefaultRepositoryManager();
        }
        return result;
    }

    public IRepositoryManager getRepositoryManager(IRepository repository) {
        IRepositoryManager result = RepositoryManagerDescriptorRegistry.getRegisteredExtensions().stream().map(IRepositoryManagerDescriptor::getRepositoryManager).filter(repoMgr -> repoMgr.canHandleAuthenticationType(repository)).findFirst().orElseGet(DefaultRepositoryManager::new);
        return result;
    }

    private static class RepositoryManagerServiceHolder {
        private static final RepositoryManagerService INSTANCE = new RepositoryManagerService();

        private RepositoryManagerServiceHolder() {
        }
    }
}

