/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartCommandResource
extends HttpServlet {
    private static final long serialVersionUID = -3309231937413701303L;
    private static final String RESTART_LOG_MESSAGE = "Restart server - called by '{}'";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        Logger logger = LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.app");
        logger.info(RESTART_LOG_MESSAGE, (Object)req.getRemoteUser());
        JsonObject result = new JsonObject();
        try {
            try {
                String message = "The server is restarting...";
                result.addProperty("message", message);
                resp.setStatus(200);
                logger.trace("Request from '{}' processed successfully. Response: {} - '{}'", new Object[]{req.getRemoteUser(), resp.getStatus(), message});
            }
            catch (Exception e) {
                String message = "An error occured the server is not able to restart.";
                result.addProperty("message", message);
                resp.setStatus(500);
                logger.error("Request from '{}' failed. Response: {} - '{}'", new Object[]{req.getRemoteUser(), resp.getStatus(), message});
                resp.getOutputStream().print(gson.toJson((JsonElement)result));
            }
        }
        finally {
            resp.getOutputStream().print(gson.toJson((JsonElement)result));
        }
    }
}

