/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.RepositoryManagerService;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CDOServerConfigFileBuilder {
    private RepositoryData repositoryData;
    private Document document;
    private OutputStream outputStream;

    public CDOServerConfigFileBuilder(RepositoryData repositoryData, OutputStream outputStream) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        this.repositoryData = repositoryData;
        this.outputStream = outputStream;
    }

    public void create() throws TransformerException {
        Comment generatedComment = this.document.createComment("This file has been generated from the init.json located in the same folder.");
        Comment modificationWarningComment = this.document.createComment("It must not be modified without doing the same corresponding changes in its input.json seed.");
        Element cdoServer = this.document.createElement("cdoserver");
        this.document.appendChild(cdoServer);
        Element repository = this.document.createElement("repository");
        repository.setAttribute("name", this.repositoryData.getRepositoryName());
        this.appendProperty(repository, "overrideUUID", "");
        this.appendProperty(repository, "supportingAudits", String.valueOf(Boolean.TRUE));
        this.appendProperty(repository, "supportingBranches", String.valueOf(Boolean.FALSE));
        this.appendProperty(repository, "supportingEcore", String.valueOf(Boolean.TRUE));
        this.appendProperty(repository, "qualifiedNames", String.valueOf(Boolean.TRUE));
        this.handleAuthentication(repository);
        Element store = this.document.createElement("store");
        store.setAttribute("type", "db");
        Element mappingStrategy = this.document.createElement("mappingStrategy");
        mappingStrategy.setAttribute("type", "horizontalAuditing");
        this.appendProperty(mappingStrategy, "qualifiedNames", String.valueOf(Boolean.TRUE));
        this.appendProperty(mappingStrategy, "toManyReferences", "ONE_TABLE_PER_REFERENCE");
        this.appendProperty(mappingStrategy, "toOneReferences", "LIKE_ATTRIBUTES");
        this.appendProperty(mappingStrategy, "forceZeroBasedIndex", String.valueOf(Boolean.TRUE));
        this.appendProperty(mappingStrategy, "withRanges", String.valueOf(Boolean.FALSE));
        store.appendChild(mappingStrategy);
        this.handleDatabase(store);
        repository.appendChild(store);
        cdoServer.appendChild(repository);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(this.outputStream);
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.transform(new DOMSource(), result);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(generatedComment), result);
        transformer.transform(new DOMSource(modificationWarningComment), result);
        transformer.transform(source, result);
    }

    private void handleDatabase(Element store) {
        IRepositoryManager databaseRepositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(this.repositoryData.getDatasourceType());
        databaseRepositoryManager.manage(this.document, store, this.repositoryData);
    }

    private void handleAuthentication(Element parent) {
        IRepositoryManager authenticationRepositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(this.repositoryData.getAuthenticationType());
        authenticationRepositoryManager.manage(this.document, parent, this.repositoryData);
    }

    private void appendProperty(Element parent, String nameAttributeValue, String valueAttributeValue) {
        Element property = this.document.createElement("property");
        property.setAttribute("name", nameAttributeValue);
        property.setAttribute("value", valueAttributeValue);
        parent.appendChild(property);
    }
}

