/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.security;

import fr.obeo.dsl.viewpoint.collab.common.internal.security.SecureStorageService;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.TokenCredential;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletRequest;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.RolePrincipal;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.security.Credential;
import org.slf4j.LoggerFactory;

public class SecureStorageLoginService
extends AbstractLoginService {
    private static final String REST_API_AUTHENTICATING_LOG_MESSAGE = "REST API - Authentication of '{}' for {}";
    private static final String REST_API_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE = "REST API - Authentication successful: '{}' for '{}'";
    private static final String REST_API_AUTHENTICATION_FAILED_LOG_MESSAGE = "REST API - Authentication failed: '{}' for {}";
    private static final String SECRET_FILENAME = "secret.txt";
    private static final String ADMIN_ROLE = "admin";
    private UserStore userStore;
    private int httpPort;
    private String configPath;

    public SecureStorageLoginService(String configPath, int httpPort) {
        this(configPath);
        this.httpPort = httpPort;
    }

    public SecureStorageLoginService(String configPath) {
        this.configPath = Objects.requireNonNull(configPath);
    }

    public List<RolePrincipal> loadRoleInfo(UserPrincipal user) {
        return this.userStore.getRolePrincipals(user.getName());
    }

    public UserPrincipal loadUserInfo(String username) {
        try {
            this.userStore = new UserStore();
            SecureStorageService storageService = new SecureStorageService(null, this.httpPort);
            this.loadUserStore(storageService);
            storageService.close();
        }
        catch (StorageException e) {
            OM.LOG.error((Throwable)e);
        }
        return this.userStore.getUserPrincipal(username);
    }

    protected void doStart() throws Exception {
        super.doStart();
        SecureStorageService storageService = new SecureStorageService(null, this.httpPort);
        if (!storageService.isHttpServerCredentialsInitialized()) {
            Optional optionalAdminToken = storageService.generateInitialAdminToken();
            optionalAdminToken.ifPresent(this::generateClearSecretToken);
        }
    }

    private void loadUserStore(SecureStorageService storageService) throws StorageException {
        List credentialsFromSecureStorage = storageService.loadCredentialsFromSecureStorage();
        credentialsFromSecureStorage.forEach(authInfo -> {
            Collection<char[]> tokenValues = authInfo.getTokens().values();
            TokenCredential credential = new TokenCredential(tokenValues);
            this.userStore.addUser(authInfo.getUserID(), (Credential)credential, new String[]{ADMIN_ROLE});
        });
    }

    private void generateClearSecretToken(char[] token) {
        File file = new File(this.configPath);
        if (file.exists() && file.isDirectory()) {
            Path path = Paths.get(file.getPath(), SECRET_FILENAME);
            try {
                Files.deleteIfExists(path);
                File secretFile = Files.createFile(path, new FileAttribute[0]).toFile();
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(secretFile);){
                        fileOutputStream.write(String.valueOf(token).getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    OM.LOG.error((Throwable)e);
                }
            }
            catch (IOException e) {
                OM.LOG.error((Throwable)e);
            }
        } else {
            OM.LOG.error(String.format("Impossible to create the %1$s file in the specified configuration file folder: %2$s", SECRET_FILENAME, this.configPath));
        }
    }

    protected void doStop() throws Exception {
        this.userStore = null;
        super.doStop();
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.rest.admin").info(REST_API_AUTHENTICATING_LOG_MESSAGE, (Object)username, (Object)request);
        UserIdentity login = super.login(username, credentials, request);
        if (login == null) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.rest.admin").error(REST_API_AUTHENTICATION_FAILED_LOG_MESSAGE, (Object)username, (Object)request);
        } else {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.rest.admin").trace(REST_API_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE, (Object)username, (Object)request);
        }
        return login;
    }
}

