/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.util;

import fr.obeo.dsl.viewpoint.collab.common.internal.commit.CommitCommentUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.SpecialUserAwareAuthenticator;
import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentials;

public final class CDOTransactionHelper {
    public static final String COMMIT_ERROR_MESSAGE = "Something unexpected happened while committing the transaction.";
    private static final String SEPARATOR = "_";
    private CDOTransaction transaction;
    private IManagedContainer container;
    private CDONet4jSession cdoNet4jSession;

    public CDOTransaction getOrCreateTransaction(final String repositoryName) {
        if (this.transaction != null) {
            return this.transaction;
        }
        Optional<SpecialUserAwareAuthenticator> specialManager = CDOTransactionHelper.installSpecificUserAuthentication(repositoryName);
        IManagedContainer createdContainer = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)createdContainer);
        JVMUtil.prepareContainer((IManagedContainer)createdContainer);
        CDONet4jUtil.prepareContainer((IManagedContainer)createdContainer);
        createdContainer.activate();
        IJVMConnector connector = JVMUtil.getConnector((IManagedContainer)createdContainer, (String)"default");
        CDONet4jSessionConfiguration sessionConfiguration = CDONet4jUtil.createNet4jSessionConfiguration();
        sessionConfiguration.setConnector((IConnector)connector);
        sessionConfiguration.setRepositoryName(repositoryName);
        sessionConfiguration.setCredentialsProvider(new IPasswordCredentialsProvider(){

            public boolean isInteractive() {
                return false;
            }

            public IPasswordCredentials getCredentials() {
                SimpleDateFormat sdf = new SimpleDateFormat("mmwwyyyyZZMMGddHH");
                return new PasswordCredentials("WEB_ADMIN", repositoryName + CDOTransactionHelper.SEPARATOR + sdf.format(System.currentTimeMillis()) + "_WEB_ADMIN");
            }
        });
        CDONet4jSession openedNet4jSession = sessionConfiguration.openNet4jSession();
        openedNet4jSession.options().setGeneratedPackageEmulationEnabled(true);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        this.transaction = openedNet4jSession.openTransaction((ResourceSet)resourceSetImpl);
        this.cdoNet4jSession = openedNet4jSession;
        this.container = createdContainer;
        this.transaction.setCommitComment("[REST Admin]");
        if (specialManager.isPresent()) {
            specialManager.get().setSpecialUserAuthenticator(null);
        }
        return this.transaction;
    }

    private static Optional<SpecialUserAwareAuthenticator> installSpecificUserAuthentication(String repositoryName) {
        SpecialUserAwareAuthenticator specialManager = null;
        BiFunction<String, char[], Boolean> authenticateSpecialUserFunction = (userId, p) -> {
            if ("WEB_ADMIN".equals(userId) && p != null && ((char[])p).length > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat("mmwwyyyyZZMMGddHH");
                return String.valueOf(p).equals(repositoryName + SEPARATOR + sdf.format(System.currentTimeMillis()) + "_WEB_ADMIN");
            }
            return false;
        };
        Optional<InternalRepository> optionalRepository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        if (optionalRepository.isPresent()) {
            InternalRepository repository = optionalRepository.get();
            ISecurityManager securityManager = SecurityManagerUtil.getSecurityManager((IRepository)repository);
            if (securityManager instanceof SpecialUserAwareAuthenticator) {
                specialManager = (SpecialUserAwareAuthenticator)securityManager;
                specialManager.setSpecialUserAuthenticator(authenticateSpecialUserFunction);
            } else {
                IAuthenticator authenticator;
                InternalSessionManager sessionManager = repository.getSessionManager();
                if (sessionManager != null && (authenticator = sessionManager.getAuthenticator()) instanceof SpecialUserAwareAuthenticator) {
                    specialManager = (SpecialUserAwareAuthenticator)authenticator;
                    specialManager.setSpecialUserAuthenticator(authenticateSpecialUserFunction);
                }
            }
        }
        return Optional.ofNullable(specialManager);
    }

    public void commitTransaction() throws ConcurrentAccessException, CommitException {
        if (this.transaction != null) {
            String commitComment = this.transaction.getCommitComment();
            if (!StringUtil.isEmpty(commitComment)) {
                this.transaction.setCommitComment(CommitCommentUtil.fitCommitDescriptionLength((String)commitComment));
            }
            try {
                this.transaction.commit();
            }
            catch (CommitException e) {
                OM.LOG.error(COMMIT_ERROR_MESSAGE, (Throwable)e);
                throw e;
            }
        }
    }

    public void disposeTransaction() {
        if (this.transaction != null) {
            this.transaction.close();
        }
        if (this.cdoNet4jSession != null) {
            this.cdoNet4jSession.close();
        }
        if (this.container != null) {
            this.container.deactivate();
        }
        this.transaction = null;
        this.cdoNet4jSession = null;
        this.container = null;
    }

    public Optional<CDOTransaction> getTransaction() {
        return Optional.ofNullable(this.transaction);
    }
}

