/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static Constructor setConstructorVisible(Class<? extends Object> classToModify, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Constructor<? extends Object> osConstructor = classToModify.getDeclaredConstructor(parameterTypes);
        osConstructor.setAccessible(true);
        return osConstructor;
    }

    public static Field setFieldVisible(Class<? extends Object> classToModify, String fieldName) throws SecurityException, NoSuchFieldException {
        Field field;
        block3: {
            field = null;
            try {
                field = classToModify.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException e) {
                if (classToModify.getSuperclass() == null) break block3;
                field = ReflectionHelper.setFieldVisible(classToModify.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getMethod(methodName, parameterTypes);
        return method.invoke(object, parameters);
    }

    public static Optional<Constructor> setConstructorVisibleWithoutException(Class<? extends Object> classToModify, Class<?> ... parameterTypes) {
        try {
            return Optional.ofNullable(ReflectionHelper.setConstructorVisible(classToModify, parameterTypes));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return Optional.empty();
        }
    }

    public static Optional<Field> setFieldVisibleWithoutException(Class<? extends Object> classToModify, String fieldName) {
        try {
            return Optional.ofNullable(ReflectionHelper.setFieldVisible(classToModify, fieldName));
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return Optional.empty();
        }
    }

    public static boolean invokeMethodWithoutException(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            ReflectionHelper.invokeMethod(object, methodName, parameterTypes, parameters);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return false;
        }
    }

    public static Object invokeMethodWithoutExceptionWithReturn(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            return ReflectionHelper.invokeMethod(object, methodName, parameterTypes, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public static Object invokeMethodWithoutExceptionWithReturn(Object object, Class aClass, String methodName, Class<?>[] parameterTypes, Object[] parameters, boolean setVisible) {
        try {
            return ReflectionHelper.invokeMethod(object, aClass, methodName, parameterTypes, parameters, setVisible);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public static Optional<Class> getClassForNameWithoutException(String className) {
        try {
            Class<?> foundClass = Class.forName(className);
            return Optional.of(foundClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }

    public static Optional<Object> instantiateWithoutException(String className, Class<?>[] parameterTypes, Object[] parameters) {
        Optional<Constructor> osConstructor;
        Optional<Class> foundClass = ReflectionHelper.getClassForNameWithoutException(className);
        if (foundClass.isPresent() && (osConstructor = ReflectionHelper.setConstructorVisibleWithoutException(foundClass.get(), parameterTypes)).isPresent()) {
            try {
                Object object = osConstructor.get().newInstance(parameters);
                return Optional.of(object);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static boolean setFieldValueWithoutException(Object instanceToModify, String fieldName, int newValue) {
        Optional<Field> field = ReflectionHelper.setFieldVisibleWithoutException(instanceToModify.getClass(), fieldName);
        if (field.isPresent()) {
            try {
                field.get().setInt(instanceToModify, newValue);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean setFieldValueWithoutException(Object instanceToModify, String fieldName, Object newValue, Class<? extends Object> classToModify) {
        Optional<Field> field = ReflectionHelper.setFieldVisibleWithoutException(classToModify, fieldName);
        if (field.isPresent()) {
            try {
                field.get().set(instanceToModify, newValue);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean setFieldValueWithoutException(Object instanceToModify, String fieldName, Object newValue) {
        Optional<Field> field = ReflectionHelper.setFieldVisibleWithoutException(instanceToModify.getClass(), fieldName);
        if (field.isPresent()) {
            try {
                field.get().set(instanceToModify, newValue);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Optional<Object> getFieldValueWithoutException(Object instance, String fieldName) {
        Optional<Field> field = ReflectionHelper.setFieldVisibleWithoutException(instance.getClass(), fieldName);
        if (field.isPresent()) {
            try {
                return Optional.ofNullable(field.get().get(instance));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<Object> getFieldValueWithoutException(Class<? extends Object> klass, String fieldName) {
        Optional<Field> field = ReflectionHelper.setFieldVisibleWithoutException(klass, fieldName);
        if (field.isPresent()) {
            try {
                return Optional.ofNullable(field.get().get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<Object> getFieldValueWithoutException(Object instance, String fieldName, Class<? extends Object> classToModify) {
        Optional<Field> field = ReflectionHelper.setFieldVisibleWithoutException(classToModify, fieldName);
        if (field.isPresent()) {
            try {
                return Optional.ofNullable(field.get().get(instance));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static boolean invokeMethodWithoutException(Object object, Class aClass, String methodName, Class<?>[] parameterTypes, Object[] parameters, boolean setVisible) {
        try {
            ReflectionHelper.invokeMethod(object, aClass, methodName, parameterTypes, parameters, setVisible);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return false;
        }
    }

    public static Object invokeMethod(Object object, Class aClass, String methodName, Class<?>[] parameterTypes, Object[] parameters, boolean setVisible) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = aClass.getDeclaredMethod(methodName, parameterTypes);
        if (setVisible) {
            method.setAccessible(true);
        }
        return method.invoke(object, parameters);
    }
}

