/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.osgi;

import fr.obeo.dsl.viewpoint.collab.server.warmup.internal.ServerWarmupListener;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;

public class CDORevisionCacheCleanupCDOCommand
extends CDOCommand.WithRepository {
    private static final String DOT = ".";

    public CDORevisionCacheCleanupCDOCommand() {
        super("revisionCacheCleanup", "cleanup CDO revision cache of a repository and call warmup worker on it.");
    }

    public void execute(InternalRepository repository, String[] args) throws Exception {
        InternalCDORevisionCache internalCDORevisionCache;
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        if (revisionManager != null && (internalCDORevisionCache = revisionManager.getCache()) instanceof InternalCDORevisionCache) {
            InternalCDORevisionCache icrc = internalCDORevisionCache;
            this.println("CDO revision cache cleanup triggered for repository " + repository.getName() + DOT);
            AtomicLong accumulator = new AtomicLong(0L);
            icrc.forEachRevision(rev -> {
                long l = accumulator.incrementAndGet();
            });
            this.println("Found " + accumulator.get() + " revisions in cache for repository " + repository.getName() + DOT);
            icrc.clear();
            AtomicLong accumulator2 = new AtomicLong(0L);
            icrc.forEachRevision(rev -> {
                long l = accumulator2.incrementAndGet();
            });
            this.println("CDO revision cache cleanup done for repository " + repository.getName() + "( cached revisions after cleanup: " + String.valueOf(accumulator2) + ")");
            List<IListener> asList = Arrays.asList(IPluginContainer.INSTANCE.getListeners());
            Optional<ServerWarmupListener> warmupWorkerLister = asList.stream().filter(ServerWarmupListener.class::isInstance).map(ServerWarmupListener.class::cast).findFirst();
            if (warmupWorkerLister.isPresent()) {
                warmupWorkerLister.get().warmup(repository);
                this.println("Warmup triggered for repository " + repository.getName());
            } else {
                this.println("No warmup worker found for repository " + repository.getName());
            }
        } else {
            this.println("No revision cache compatible with the revisionCacheCleanup command for repository " + repository.getName() + DOT);
        }
    }
}

