/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.h2.contribution;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.h2.internal.H2RepositoryManagerUtil;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.cdo.server.IRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class H2FileRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "H2_EMBEDDED";

    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        H2RepositoryManagerUtil.createTag2HandleH2Database(document, parentElement, this.buildUrl(repositoryData));
    }

    private String buildUrl(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        StringBuilder urlBuilder = new StringBuilder("jdbc:h2:");
        Object path = String.valueOf(repositoryData.getConfigurationFolderPath());
        if (!"".equals(path)) {
            path = (String)path + File.separator;
        }
        urlBuilder.append((String)path);
        urlBuilder.append(repositoryName).append(File.separator);
        urlBuilder.append("_database");
        if (urlBuilder.charAt(urlBuilder.length() - 1) != '/' && urlBuilder.charAt(urlBuilder.length() - 1) != '\\') {
            urlBuilder.append(File.separatorChar);
        }
        urlBuilder.append(repositoryName);
        urlBuilder.append(";DB_CLOSE_ON_EXIT=FALSE");
        return urlBuilder.toString();
    }

    public Optional<IRepository> prepareRepositoryForImport(RepositoryData repositoryData) {
        return H2RepositoryManagerUtil.createRepositoryFromConfiguration(repositoryData.getRepositoryName());
    }

    public String getKey() {
        return KEY;
    }

    public String validateData(Map<String, Object> data) {
        return "NO_ISSUE_DIAGNOSTIC";
    }

    public String validateNewUser(NewUser newUser, String repositoryName) {
        return "Users are not managed by this repository manager.";
    }
}

