/*******************************************************************************
 * Copyright (c) 2025 THALES GLOBAL SERVICES.
 * All rights reserved.
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.jwt;

/**
 * Result of the JWT checks. It allows to get the check status, the user info to display in UI (and potentially to match
 * with user manager) or get the error message if access is not granted.
 * 
 */
public class JWTCheckResult {

    /**
     * Status code for internal server error.
     */
    public static final int SC_INTERNAL_SERVER_ERROR = 500;

    /**
     * Status code for forbidden access in case of JWT validation error.
     */
    public static final int SC_FORBIDDEN = 403;

    /**
     * Status code indicating that JWT validation ran correctly : check the isAccessGranted for repository access
     * authorization.
     */
    public static final int SC_OK = 200;

    private boolean accessGranted;

    private String userInfoClaim = "name"; //$NON-NLS-1$

    private String errorMessage = ""; //$NON-NLS-1$

    private int status = SC_INTERNAL_SERVER_ERROR;

    /**
     * Constructor.
     * 
     * @param userInfoClaim
     *            userInfoClaim value
     * @param accessGranted
     */
    public JWTCheckResult(String userInfoClaim, boolean accessGranted) {
        this.accessGranted = accessGranted;
        this.userInfoClaim = userInfoClaim;
        this.status = SC_OK;
    }

    /**
     * Constructor.
     * 
     * @param accessGranted
     *            check result
     * @param errorMessage
     *            an error message
     * @param errorStatus
     *            an HttpServletResponse status
     */
    public JWTCheckResult(String userInfoClaim, String errorMessage, int errorStatus) {
        this.accessGranted = false;
        this.userInfoClaim = userInfoClaim;
        this.errorMessage = errorMessage;
        this.status = errorStatus;
    }

    public boolean isAccessGranted() {
        return accessGranted;
    }

    public String getUserInfoClaim() {
        return userInfoClaim;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public int getStatus() {
        return status;
    }

}
