/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.osgi;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalRepository;

public class CDORevisionCacheInfoCDOCommand
extends CDOCommand.WithRepository {
    private static final String DOT = ".";

    public CDORevisionCacheInfoCDOCommand() {
        super("revisionCacheInfo", "display information about CDO Revision cache of the repository.");
    }

    public void execute(InternalRepository repository, String[] args) throws Exception {
        InternalCDORevisionCache internalCDORevisionCache;
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        if (revisionManager != null && (internalCDORevisionCache = revisionManager.getCache()) instanceof CDORevisionCache) {
            CDORevisionCache crc = (CDORevisionCache)internalCDORevisionCache;
            this.println("CDO revision cache info lookup for repository " + repository.getName() + DOT);
            AtomicLong accumulator = new AtomicLong(0L);
            crc.forEachRevision(rev -> {
                long l = accumulator.incrementAndGet();
            });
            this.println("Found " + accumulator.get() + " revisions in cache for repository " + repository.getName() + DOT);
        } else {
            this.println("No revision cache compatible with the revisionCacheInfo command for repository " + repository.getName() + DOT);
        }
    }
}

