/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth;

import fr.obeo.dsl.viewpoint.collab.common.internal.jwt.JWTCheckResult;
import fr.obeo.dsl.viewpoint.collab.common.internal.security.BCryptService;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt.AuthenticationCodeFlowJWTHelper;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.SpecialUserAwareAuthenticator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.PluginRepositoryProvider;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.slf4j.LoggerFactory;

public class OpenIDAuthenticator
implements IAuthenticator,
SpecialUserAwareAuthenticator {
    public static final String INVALID_PASSWORD_MESSAGE = "The password does not contains the required information.";
    private static final String INVALID_REPOSITORY_MESSAGE = "The same authenticator instance is used by several repositories. Cannot perform token validation.";
    private static final String NO_REPOSITORY_MESSAGE = "No repository found using the current authenticator. Cannot perform token validation.";
    private static final String OPENID_SEARCH_USER_ERROR = "Error while looking up in authentication server. Search query returned no users. ";
    private static final String OPEN_ID_AUTHENTICATING_LOG_MESSAGE = "OpenID Connect - Authentication of '{}'";
    private static final String OPEN_ID_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE = "OpenID Connect - Authentication successful for '{}'";
    private static final String OPENID_AUTHENTICATION_FAILED = "OpenID Connect - Authentication failed for '{}' with error : '{}'";
    private OpenIDAuthenticatorConfig config;
    private BiFunction<String, char[], Boolean> authenticateSpecialUserFunction;

    public OpenIDAuthenticator(OpenIDAuthenticatorConfig config) {
        this.config = config;
    }

    public void authenticate(String userID, char[] password) throws SecurityException {
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").info(OPEN_ID_AUTHENTICATING_LOG_MESSAGE, (Object)userID);
        boolean isWebAdmin = false;
        if (this.authenticateSpecialUserFunction != null && (isWebAdmin = this.authenticateSpecialUserFunction.apply(userID, password).booleanValue())) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").trace(OPEN_ID_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE, (Object)userID);
            return;
        }
        if (password == null || password.length == 0 || String.valueOf(password).trim().isEmpty()) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_AUTHENTICATION_FAILED, (Object)userID, (Object)INVALID_PASSWORD_MESSAGE);
            throw new SecurityException(INVALID_PASSWORD_MESSAGE);
        }
        boolean authenticationSucceeded = false;
        String jwtMessage = "";
        if ("code".equalsIgnoreCase(this.config.getResponseType())) {
            String[] tokens = String.valueOf(password).split(":");
            if (tokens.length == 2) {
                String idToken = tokens[0];
                String accessToken = tokens[1];
                String repoName = this.getCurrentRepostitoryName("Unknown");
                AuthenticationCodeFlowJWTHelper jwtHelper = new AuthenticationCodeFlowJWTHelper(userID, repoName, this.config);
                JWTCheckResult result = jwtHelper.check(Optional.ofNullable(idToken), Optional.ofNullable(accessToken));
                authenticationSucceeded = result.isAccessGranted();
                jwtMessage = result.getErrorMessage();
            }
        } else {
            authenticationSucceeded = this.config.getImplicitFlowUserAuthenticationRegistry().isUserConnected(userID, String.valueOf(password).trim());
            this.config.getImplicitFlowUserAuthenticationRegistry().unregisterUser(String.valueOf(password).trim());
        }
        if (!authenticationSucceeded) {
            if (this.config.getTechnicalUsers().containsKey(userID)) {
                this.authenticateTechnicalUser(userID, password);
            } else {
                String errorMessage = OPENID_SEARCH_USER_ERROR;
                if (!StringUtil.isEmpty((String)jwtMessage)) {
                    errorMessage = jwtMessage;
                }
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_AUTHENTICATION_FAILED, (Object)userID, (Object)errorMessage);
                throw new SecurityException(errorMessage);
            }
        }
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").trace(OPEN_ID_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE, (Object)userID);
    }

    private String getCurrentRepostitoryName(String userID) {
        IRepository currentRepo = null;
        Object[] elements = PluginRepositoryProvider.INSTANCE.getContainer().getElements("org.eclipse.emf.cdo.server.repositories", "default");
        if (elements != null) {
            List<IRepository> reposWithCurrentAuthenticator = Arrays.asList(elements).stream().filter(IRepository.class::isInstance).map(IRepository.class::cast).filter(repository -> OpenIdConnectUtil.getOpenIdAuthenticator(repository).filter(auth -> auth == this).isPresent()).toList();
            if (reposWithCurrentAuthenticator.size() != 1) {
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_AUTHENTICATION_FAILED, (Object)userID, (Object)INVALID_REPOSITORY_MESSAGE);
                throw new SecurityException(INVALID_REPOSITORY_MESSAGE);
            }
            currentRepo = reposWithCurrentAuthenticator.iterator().next();
        }
        if (currentRepo == null) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_AUTHENTICATION_FAILED, (Object)userID, (Object)NO_REPOSITORY_MESSAGE);
            throw new SecurityException(NO_REPOSITORY_MESSAGE);
        }
        return currentRepo.getName();
    }

    private void authenticateTechnicalUser(String userID, char[] password) {
        if (!BCryptService.verify((String)new String(this.config.getTechnicalUsers().get(userID)), (char[])password)) {
            String securityExceptionMessage = "Access denied. Invalid credentials for the technical user.";
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_AUTHENTICATION_FAILED, (Object)userID, (Object)securityExceptionMessage);
            throw new SecurityException(securityExceptionMessage);
        }
    }

    public OpenIDAuthenticatorConfig getConfig() {
        return this.config;
    }

    public void setConfig(OpenIDAuthenticatorConfig config) {
        this.config = config;
    }

    public void setSpecialUserAuthenticator(BiFunction<String, char[], Boolean> isSpecialUserAuthenticator) {
        this.authenticateSpecialUserFunction = isSpecialUserAuthenticator;
    }
}

