/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth;

import com.google.gson.Gson;
import fr.obeo.dsl.viewpoint.collab.common.internal.helper.CollabConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.common.internal.http.helper.HttpRequestHelper;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.DiscoverEndPointResponse;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.user.ImplicitFlowUserAuthenticationRegistry;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.configuration.CollabServerConfigPropertiesHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.security.IAuthenticator;

public class OpenIDAuthenticatorConfig
implements IAuthenticatorConfig {
    private File configurationFolder;
    @ReflectUtil.ExcludeFromDump
    private Map<String, char[]> technicalUsers = new LinkedHashMap<String, char[]>();
    private Properties props;
    private String authorizationtEndPointURL;
    private String userInfoEndPointURL;
    private String tokenEndPointURL;
    private String signoutEndpointURL;
    private String jwksURL;
    private String issuer;
    private String tenant;
    private String clientID;
    private String scope;
    private String responseType;
    private String acrValues;
    private String complement;
    private int loginTimeoutMS;
    private String loopbackServerName;
    private int loopbackServerPort;
    private String userInfoPayload;
    private String userInfoMatchClaim;
    private String repositoryFilterPayload;
    private boolean repositoryFilterPayloadCheckScope;
    private String repositoryFilterMatchClaim;
    private String repositoryFilterMatchPrefix;
    private String repositoryFilterMatchValue;
    private String accessTokenAudience;
    private String implicitFlowState;
    private String implicitFlowWebServerURL;
    private ImplicitFlowUserAuthenticationRegistry implicitFlowUserAuthenticationRegistry = new ImplicitFlowUserAuthenticationRegistry();

    public OpenIDAuthenticatorConfig(Properties props, File configurationFolder) {
        this.props = props;
        this.configurationFolder = configurationFolder;
        this.tenant = this.getConfigValue("tenant");
        this.clientID = this.getConfigValue("clientID");
        this.scope = this.getConfigValue("scope", "openid+profile+email");
        this.responseType = this.getConfigValue("responseType", "id_token+token");
        this.acrValues = this.getConfigValue("acrValues", "");
        this.complement = this.getConfigValue("complement", "");
        this.userInfoMatchClaim = this.getConfigValue("userInfoMatchClaim", "name");
        this.userInfoPayload = this.getConfigValue("userInfoPayload", "userInfoEndpoint");
        String claim = "repository";
        Optional<String> customDefaultRepositoryFilterMatchClaim = OM.Activator.getDefault().getCustomDefaultRepositoryFilterMatchClaim();
        if (customDefaultRepositoryFilterMatchClaim.isPresent() && !StringUtil.isEmpty((String)customDefaultRepositoryFilterMatchClaim.get())) {
            claim = customDefaultRepositoryFilterMatchClaim.get();
        }
        this.repositoryFilterMatchClaim = this.getConfigValue("repositoryFilterMatchClaim", claim);
        this.repositoryFilterMatchPrefix = this.getConfigValue("repositoryFilterMatchPrefix", "");
        this.repositoryFilterMatchValue = this.getConfigValue("repositoryFilterMatchValue", "");
        this.repositoryFilterPayload = this.getConfigValue("repositoryFilterPayload", "");
        this.repositoryFilterPayloadCheckScope = Boolean.parseBoolean(this.getConfigValue("repositoryFilterPayload.checkScope", "true"));
        this.accessTokenAudience = this.getConfigValue("accessTokenAudience", "");
        this.implicitFlowWebServerURL = this.getConfigValue("webServerURL");
        this.implicitFlowState = this.getConfigValue("state", UUID.randomUUID().toString());
        String timeout = this.getConfigValue("login.timeout.ms", String.valueOf(10000));
        int timeoutMS = 10000;
        try {
            timeoutMS = Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            OM.LOG.error(String.format("Invalid value set for  property '%s': '%s' is not an integer. '%s' will be used instead.", "login.timeout.ms", timeout, 10000), (Throwable)e);
        }
        if (timeoutMS < 10) {
            OM.LOG.warn(String.format("Invalid value set for property '%s': %d is < 10. The timeout will be set to 10ms, although it is recommended to set it to more than 1000 ms.", "login.timeout.ms", timeoutMS));
        }
        this.loginTimeoutMS = Math.max(timeoutMS, 10);
        this.loopbackServerName = this.getConfigValue("loopback.server.port", "localhost");
        String lsPort = this.getConfigValue("loopback.server.name", String.valueOf(-1));
        int lsPortInt = -1;
        try {
            lsPortInt = Integer.parseInt(lsPort);
        }
        catch (NumberFormatException e) {
            OM.LOG.error(String.format("Invalid value set for  property '%s': '%s' is not an integer. '%s' will be used instead.", "loopback.server.name", lsPort, -1), (Throwable)e);
        }
        this.loopbackServerPort = lsPortInt;
        this.readTechnicalUsers(this.getConfigValue("technicalUsers.file.path", "technicalUsers.properties"));
    }

    private void readTechnicalUsers(String filePath) {
        if (filePath != null) {
            CollabServerConfigPropertiesHelper helper = new CollabServerConfigPropertiesHelper(filePath, "Technical users properties file");
            helper.load();
            Properties properties = helper.getProperties();
            for (Object key : properties.keySet()) {
                Object object = properties.get(key);
                if (!(key instanceof String) || !(object instanceof String) || ((String)object).isEmpty()) continue;
                this.technicalUsers.put((String)key, ((String)object).toCharArray());
            }
        }
    }

    public void saveTechnicalUserConfigFile() {
        String filePath = this.getConfigValue("technicalUsers.file.path", "technicalUsers.properties");
        if (filePath != null) {
            CollabServerConfigPropertiesHelper helper = new CollabServerConfigPropertiesHelper(filePath, "Technical users properties file");
            helper.load();
            File configFile = helper.getConfigFile();
            Properties technicaProps = new Properties();
            for (Map.Entry<String, char[]> entry : this.technicalUsers.entrySet()) {
                technicaProps.put(entry.getKey(), new String(entry.getValue()));
            }
            String comment = MessageFormat.format("Technical user database {0,date} {0,time,HH:mm:ss:SSS}", System.currentTimeMillis());
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(configFile);
                    technicaProps.store(fos, comment);
                }
                catch (IOException e) {
                    throw new ProductCreationException("Technical users file cannot be saved", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
            IOUtil.close((Closeable)fos);
        }
    }

    public Map<String, char[]> getTechnicalUsers() {
        return this.technicalUsers;
    }

    private String getConfigValue(String propertyKey) {
        return this.getConfigValue(propertyKey, null);
    }

    private String getConfigValue(String propertyKey, String defaultValue) {
        String systemPropertyKey = "fr.obeo.dsl.viewpoint.collab.server.openid." + propertyKey;
        String configPropertyKey = "openIDConnect." + propertyKey;
        String propertyValue = this.getPropertyValue(configPropertyKey, defaultValue);
        return CollabConfigurationHelper.getProperty((String)systemPropertyKey, (String)propertyValue);
    }

    private String getPropertyValue(String propertyKey, String defaultValue) {
        String value = this.props.getProperty(propertyKey, defaultValue);
        if (value != null && (value = value.trim()).endsWith("/")) {
            value = value.subSequence(0, value.length() - 1).toString();
        }
        return value;
    }

    public File getConfigurationFolder() {
        return this.configurationFolder;
    }

    public void setConfigurationFolder(File configurationFolder) {
        this.configurationFolder = configurationFolder;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getUserInfoMatchClaim() {
        return this.userInfoMatchClaim;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public String getComplement() {
        return this.complement;
    }

    public int getLoginTimeoutMS() {
        return this.loginTimeoutMS;
    }

    public String getLoopbackServerName() {
        return this.loopbackServerName;
    }

    public int getLoopbackServerPort() {
        return this.loopbackServerPort;
    }

    public String getUserInfoPayload() {
        return this.userInfoPayload;
    }

    public String getRepositoryFilterPayload() {
        return this.repositoryFilterPayload;
    }

    public boolean isRepositoryFilterPayloadCheckScope() {
        return this.repositoryFilterPayloadCheckScope;
    }

    public String getRepositoryFilterMatchClaim() {
        return this.repositoryFilterMatchClaim;
    }

    public String getRepositoryFilterMatchPrefix() {
        return this.repositoryFilterMatchPrefix;
    }

    public String getRepositoryFilterMatchValue() {
        return this.repositoryFilterMatchValue;
    }

    public String getAccessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String getImplicitFlowState() {
        return this.implicitFlowState;
    }

    public String getImplicitFlowWebServerURL() {
        return this.implicitFlowWebServerURL;
    }

    public ImplicitFlowUserAuthenticationRegistry getImplicitFlowUserAuthenticationRegistry() {
        return this.implicitFlowUserAuthenticationRegistry;
    }

    public String getEncodedURL(String decodedURL) {
        String encodedURL = null;
        try {
            encodedURL = URLEncoder.encode(decodedURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            OM.LOG.error("Error while encoding the redirection URI", (Throwable)e);
        }
        return encodedURL;
    }

    public String getAuthorizationtEndPointURI() {
        if (this.authorizationtEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.authorizationtEndPointURL;
    }

    public String getUserInfoEndPointURI() {
        if (this.userInfoEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.userInfoEndPointURL;
    }

    public String getTokenEndPointURI() {
        if (this.tokenEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.tokenEndPointURL;
    }

    public String getJwksURI() {
        if (this.jwksURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.jwksURL;
    }

    public String getIssuerURI() {
        if (this.issuer == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.issuer;
    }

    private void exploreDiscoveryEndPoint() {
        String patternDiscoveryURL = this.getConfigValue("discoveryURL");
        if (!this.getTenant().isEmpty() && patternDiscoveryURL.contains("{tenant}")) {
            patternDiscoveryURL = patternDiscoveryURL.replace("{tenant}", this.getTenant());
        }
        StringBuilder responseStr = new StringBuilder();
        HttpRequestHelper.callHttpService((String)patternDiscoveryURL, new LinkedHashMap(), (StringBuilder)responseStr);
        DiscoverEndPointResponse discoveryResponse = (DiscoverEndPointResponse)new Gson().fromJson(responseStr.toString(), DiscoverEndPointResponse.class);
        this.authorizationtEndPointURL = discoveryResponse.getAuthorization_endpoint();
        this.userInfoEndPointURL = discoveryResponse.getUserinfo_endpoint();
        this.tokenEndPointURL = discoveryResponse.getToken_endpoint();
        this.signoutEndpointURL = discoveryResponse.getEnd_session_endpoint();
        this.jwksURL = discoveryResponse.getJwks_uri();
        this.issuer = discoveryResponse.getIssuer();
    }

    public String computeImplicitFlowAuthenticationRequestURI(String computedServerUrl) {
        String optionalComplement;
        String optionalAcrValues;
        String serverUrlToUse = this.getServerURL(computedServerUrl);
        Object computedURL = this.getAuthorizationtEndPointURI();
        computedURL = (String)computedURL + "?client_id=" + this.getClientID();
        computedURL = (String)computedURL + "&response_type=" + this.getResponseType();
        computedURL = (String)computedURL + "&redirect_uri=" + this.getEncodedURL(serverUrlToUse + "/auth/redirect");
        computedURL = (String)computedURL + "&scope=" + this.getScope();
        String nonce = UUID.randomUUID().toString();
        this.getImplicitFlowUserAuthenticationRegistry().registerAuthenticationSession(nonce);
        computedURL = (String)computedURL + "&nonce=" + nonce;
        computedURL = (String)computedURL + "&response_mode=form_post";
        String optionalState = this.getImplicitFlowState();
        if (!StringUtil.isEmpty((String)optionalState)) {
            computedURL = (String)computedURL + "&state=" + optionalState;
        }
        if (!StringUtil.isEmpty((String)(optionalAcrValues = this.getAcrValues()))) {
            computedURL = (String)computedURL + "&acr_values=" + optionalAcrValues;
        }
        if (!StringUtil.isEmpty((String)(optionalComplement = this.getComplement()))) {
            computedURL = (String)computedURL + optionalComplement;
        }
        return computedURL;
    }

    private String getServerURL(String computedServerUrl) {
        String serverUrlToUse = computedServerUrl;
        if (this.implicitFlowWebServerURL != null && !this.implicitFlowWebServerURL.isEmpty()) {
            serverUrlToUse = this.implicitFlowWebServerURL;
        }
        return serverUrlToUse;
    }

    public String computeImplicitFlowSignOutRequestURL(String computedServerUrl) {
        String serverUrlToUse = this.getServerURL(computedServerUrl);
        Object signoutURL = this.signoutEndpointURL;
        signoutURL = (String)signoutURL + "?post_logout_redirect_uri=" + this.getEncodedURL(serverUrlToUse + "/auth/signin/");
        return signoutURL;
    }

    public IAuthenticator instanciateAuthenticator() {
        return new OpenIDAuthenticator(this);
    }
}

