/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.contribution.openidconnect;

import fr.obeo.dsl.viewpoint.collab.common.internal.security.BCryptService;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.SpecialUserUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.UserUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenIdConnectAuthenticationRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    public static final String USERS_CANNOT_BE_CREATED = "Non technical user creation is not supported, repository %1$s does not manage users but only authentication with OpenID Connect. Contact your OpenID Connect administrator if you need to add a new user.";
    private static final String KEY = "OPENIDC";
    private static final String DESCRIPTION_XML_TAG_ATTRIBUTE = "description";
    private static final String TYPE_XML_TAG_ATTRIBUTE = "type";
    private static final String AUTHENTICATOR_XML_TAG = "authenticator";
    private static final String OPENIDC_CONFIG_PROPERTIES_FILE = "openidc.properties";

    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        String propertiesFilePath = this.createPropertiesFile(repositoryData);
        Element element = document.createElement(AUTHENTICATOR_XML_TAG);
        element.setAttribute(TYPE_XML_TAG_ATTRIBUTE, "openidconnect");
        element.setAttribute(DESCRIPTION_XML_TAG_ATTRIBUTE, propertiesFilePath);
        parentElement.appendChild(element);
    }

    private String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        String configFolder = repositoryData.getConfigurationFolderPath() + File.separator + repositoryName + File.separator;
        String userProfileConfigurationFilePath = configFolder + OPENIDC_CONFIG_PROPERTIES_FILE;
        Map authenticationData = repositoryData.getAuthenticationData();
        Map<String, String> openIdConnectProperties = OpenIdConnectUtil.addOpenIdConnectPropertiesToMap(authenticationData, true, configFolder);
        try {
            CommonUtil.createProperiesFileFromMap((String)userProfileConfigurationFilePath, openIdConnectProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The OpenID Connect configuration properties file (%1$s) has not been created.", userProfileConfigurationFilePath), (Throwable)e);
        }
        String technicalUserPropertiesFile = OpenIdConnectUtil.getTechnicalUsersPropertiesFile(authenticationData, configFolder);
        try {
            LinkedHashMap technicalUsersProperties = new LinkedHashMap();
            CommonUtil.createProperiesFileFromMap((String)technicalUserPropertiesFile, technicalUsersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The technical users properties file (%1$s) has not been created", technicalUserPropertiesFile), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    public String getKey() {
        return KEY;
    }

    public String validateData(Map<String, Object> data) {
        return OpenIdConnectUtil.validateOpenIdConnectAuthenticationData(data);
    }

    public String validateNewUser(NewUser newUser, String repositoryName) {
        if (newUser.isTechnical()) {
            String diag;
            String diagnostic = "NO_ISSUE_DIAGNOSTIC";
            StringBuilder detectedIssues = new StringBuilder();
            if (newUser.isAdministrator()) {
                diag = String.format("The admin user %1$s cannot be added in the repository %2$s: administrator users are not managed.", newUser.getId(), repositoryName);
                AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)diag);
            }
            if (!"NO_ISSUE_DIAGNOSTIC".equals(diag = UserUtil.validateUserPassword((String)newUser.getPassword(), (String)"The password has not been provided."))) {
                AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)diag);
            }
            if (detectedIssues.length() > 0) {
                diagnostic = detectedIssues.toString();
            }
            return diagnostic;
        }
        return String.format(USERS_CANNOT_BE_CREATED, repositoryName);
    }

    public boolean canHandleAuthenticationType(IRepository repository) {
        return this.getOpenIDAuthenticator(Optional.ofNullable(repository)).isPresent();
    }

    public IStatus createUser(String repositoryName, NewUser newUser) {
        if (newUser.isTechnical()) {
            String password = BCryptService.hash((char[])newUser.getPassword().toCharArray());
            newUser.setPassword(null);
            Optional<OpenIDAuthenticator> oia = this.getOpenIDAuthenticator(repositoryName);
            if (oia.isPresent()) {
                OpenIDAuthenticatorConfig config = oia.get().getConfig();
                config.getTechnicalUsers().put(newUser.getId(), password.toCharArray());
                config.saveTechnicalUserConfigFile();
                return Status.OK_STATUS;
            }
        }
        return super.createUser(repositoryName, newUser);
    }

    public IStatus deleteUser(String repositoryName, String username) {
        OpenIDAuthenticatorConfig config;
        Optional<OpenIDAuthenticator> oia = this.getOpenIDAuthenticator(repositoryName);
        if (oia.isPresent() && (config = oia.get().getConfig()).getTechnicalUsers().containsKey(username)) {
            config.getTechnicalUsers().remove(username);
            config.saveTechnicalUserConfigFile();
            return Status.OK_STATUS;
        }
        return super.deleteUser(repositoryName, username);
    }

    public List<SimpleUser> getAllUsers(String repositoryName) {
        ArrayList<SimpleUser> users = new ArrayList<SimpleUser>();
        List technicalUserIds = this.getOpenIDAuthenticator(repositoryName).map(OpenIDAuthenticator::getConfig).map(OpenIDAuthenticatorConfig::getTechnicalUsers).stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toList());
        List simpleUsers = technicalUserIds.stream().filter(userId -> !SpecialUserUtil.isSpecialUser((String)userId)).map(userId -> {
            SimpleUser simpleUser = new SimpleUser();
            simpleUser.setId(userId);
            simpleUser.setTechnical(true);
            return simpleUser;
        }).collect(Collectors.toList());
        users.addAll(simpleUsers);
        return users;
    }

    private Optional<OpenIDAuthenticator> getOpenIDAuthenticator(String repositoryName) {
        Optional repository = CDORepositoryUtil.getRepositoryFromName((String)repositoryName);
        if (repository.isPresent()) {
            return this.getOpenIDAuthenticator(repository);
        }
        return Optional.empty();
    }

    private Optional<OpenIDAuthenticator> getOpenIDAuthenticator(Optional<? extends IRepository> repository) {
        Optional<InternalSecurityManager> securityManager = repository.map(r -> SecurityManager.get((IRepository)r));
        Optional<IAuthenticator> authenticator = this.getAuthenticator(repository);
        if (securityManager.isEmpty() && authenticator.isPresent()) {
            OpenIDAuthenticator oia = null;
            if (authenticator.get() instanceof OpenIDAuthenticator) {
                oia = (OpenIDAuthenticator)authenticator.get();
            }
            return Optional.ofNullable(oia);
        }
        return Optional.empty();
    }

    private Optional<IAuthenticator> getAuthenticator(Optional<? extends IRepository> repository) {
        return repository.map(IRepository::getSessionManager).map(ISessionManager::getAuthenticator);
    }
}

