/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.http;

import fr.obeo.dsl.viewpoint.collab.common.internal.http.auth.AuthInformationCookie;
import fr.obeo.dsl.viewpoint.collab.common.internal.jwt.JWTCheckResult;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.http.AbstractAuthenticationResource;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt.LegacyImplicitFlowJWTHelper;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;

public class AuthenticationRedirectResource
extends AbstractAuthenticationResource {
    public static final String ALIAS = "/auth/redirect";
    private static final String ERROR_MESSAGE = "The user can not be authenticated.";
    private static final String HTTP_REQ_STATE_PARAMETER = "state";
    private static final String OPENID_REPOSITORYACCESS_FAILED = "OpenID Connect - Access not granted on repository '{}' for user '{}': no repository claim.";
    private static final String OPENID_REDIRECT_ERROR = "Error received on OpenId Connect redirect uri";
    private static final String REPOSITORY_INFORMATION_LOST_ERROR = "Repository information has been lost in the authentication process. Check that the client authorizes sending the cookies";
    private static final String OPENID_INTERNAL_CONFIGURATION_ERROR = "OpenId Connect internal configuration information can not be retrieved";
    private static final String RESPONSE_DASH = " - ";
    private static final long serialVersionUID = -4118973169902165544L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String error = req.getParameter("error");
        String errorDescription = req.getParameter("error_description");
        String errorUri = req.getParameter("error_uri");
        String repositoryName = this.getRepositoryNameFromCookie(req);
        Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository = this.getOpenIDConfigForRepository(repositoryName);
        if (repositoryName == null || repositoryName.isBlank()) {
            this.sendErrorResponse(resp, REPOSITORY_INFORMATION_LOST_ERROR, 400, req.getRemoteUser());
        } else if (!openIDConfigForRepository.isPresent()) {
            this.sendErrorResponse(resp, OPENID_INTERNAL_CONFIGURATION_ERROR, 500, req.getRemoteUser());
        } else if (!StringUtil.isEmpty((String)error)) {
            ErrorResponse response = ResponseFactory.createErrorResponse((String)ERROR_MESSAGE, (int)400, (String)OPENID_REDIRECT_ERROR);
            this.redirectToFailurePage(resp, response, openIDConfigForRepository, req.getRemoteUser(), error, errorDescription, errorUri);
        } else {
            String expectedState = openIDConfigForRepository.get().getImplicitFlowState();
            boolean emptyExpectedState = StringUtil.isEmpty((String)expectedState);
            String stateReqParameter = req.getParameter(HTTP_REQ_STATE_PARAMETER);
            if (emptyExpectedState && StringUtil.isEmpty((String)stateReqParameter) || !emptyExpectedState && expectedState.equals(stateReqParameter)) {
                this.registerUserAndRedirect(req, resp, repositoryName, openIDConfigForRepository.get());
            } else {
                ErrorResponse response = ResponseFactory.createErrorResponse((String)ERROR_MESSAGE, (int)400, (String)"Invalid state for OpenIdConnect redirect call");
                this.redirectToFailurePage(resp, response, openIDConfigForRepository, req.getRemoteUser(), "", "", "");
            }
        }
    }

    private void registerUserAndRedirect(HttpServletRequest req, HttpServletResponse resp, String repositoryName, OpenIDAuthenticatorConfig openIDConfigForRepository) throws IOException {
        Optional<String> accessToken;
        LegacyImplicitFlowJWTHelper jwtHelper = new LegacyImplicitFlowJWTHelper(repositoryName, openIDConfigForRepository);
        Optional<String> idToken = Optional.ofNullable(req.getParameter("id_token"));
        JWTCheckResult result = jwtHelper.check(idToken, accessToken = Optional.ofNullable(req.getParameter("access_token")));
        if (result.isAccessGranted()) {
            this.registerUserAndRedirect(req, resp, result.getUserInfoClaim(), repositoryName, openIDConfigForRepository, idToken);
        } else if (result.getStatus() == 200) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(OPENID_REPOSITORYACCESS_FAILED, (Object)repositoryName, (Object)result.getUserInfoClaim());
            String id = UUID.randomUUID().toString();
            AuthInformationCookie authInformationCookie = new AuthInformationCookie(id, result.getUserInfoClaim());
            String cookieValue = authInformationCookie.getCookieValue();
            resp.addCookie(new Cookie("fr.obeo.dsl.viewpoint.collab.openidconnectInformation", cookieValue));
            String authenticationRequestURL = this.getRedirectURL("/auth/fail", Optional.of(openIDConfigForRepository));
            resp.sendRedirect(authenticationRequestURL);
        } else {
            resp.addCookie(new Cookie("fr.obeo.dsl.viewpoint.collab.openidconnectInformation", ""));
            ErrorResponse response = ResponseFactory.createErrorResponse((String)ERROR_MESSAGE, (int)result.getStatus(), (String)result.getErrorMessage());
            this.redirectToFailurePage(resp, response, Optional.of(openIDConfigForRepository), req.getRemoteUser(), "", "", "");
        }
    }

    private void registerUserAndRedirect(HttpServletRequest req, HttpServletResponse resp, String userInfoClaim, String repositoryName, OpenIDAuthenticatorConfig openIDConfigForRepository, Optional<String> idToken) throws IOException {
        if (StringUtil.isEmpty((String)userInfoClaim)) {
            ErrorResponse response = ResponseFactory.createErrorResponse((String)ERROR_MESSAGE, (int)401, (String)"User information cannot be retrieved.");
            this.redirectToFailurePage(resp, response, Optional.of(openIDConfigForRepository), req.getRemoteUser(), "", "", "");
        } else {
            String id = UUID.randomUUID().toString();
            openIDConfigForRepository.getImplicitFlowUserAuthenticationRegistry().registerUser(id, userInfoClaim);
            AuthInformationCookie authInformationCookie = new AuthInformationCookie(id, userInfoClaim);
            String cookieValue = authInformationCookie.getCookieValue();
            resp.addCookie(new Cookie("fr.obeo.dsl.viewpoint.collab.openidconnectInformation", cookieValue));
            Object authenticationRequestURL = this.getRedirectURL("/auth/success", Optional.of(openIDConfigForRepository));
            if (idToken.isPresent()) {
                authenticationRequestURL = (String)authenticationRequestURL + "?id_token=" + idToken.get();
            }
            resp.sendRedirect((String)authenticationRequestURL);
        }
    }

    private void sendErrorResponse(HttpServletResponse resp, String responseStr, int status, String remoteUser) throws IOException {
        ErrorResponse response = ResponseFactory.createErrorResponse((String)ERROR_MESSAGE, (int)status, (String)responseStr);
        OM.LOG.error(response.getMessage() + RESPONSE_DASH + response.getError());
        this.sendErrorResponse(resp, response, remoteUser);
    }

    private void sendErrorResponse(HttpServletResponse resp, ErrorResponse response, String remoteUser) throws IOException {
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write((HttpServletResponse)resp, response.getClass(), (Object)response, (String)remoteUser, (String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j");
    }

    private void redirectToFailurePage(HttpServletResponse resp, ErrorResponse response, Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository, String remoteUser, String error, String errorDescription, String errorURI) throws IOException {
        String redirectMessage = response.getError();
        String redirectError = "";
        String redirectErrorDescription = "";
        String redirectErrorURI = "";
        Object responseError = response.getError();
        if (!StringUtil.isEmpty((String)error)) {
            responseError = (String)responseError + RESPONSE_DASH + error;
            redirectError = error;
        }
        if (!StringUtil.isEmpty((String)errorDescription)) {
            responseError = (String)responseError + RESPONSE_DASH + errorDescription;
            redirectErrorDescription = errorDescription;
        }
        if (!StringUtil.isEmpty((String)errorURI)) {
            responseError = (String)responseError + RESPONSE_DASH + errorURI;
            redirectErrorURI = errorURI;
        }
        if (StringUtil.isEmpty((String)error) && StringUtil.isEmpty((String)errorDescription)) {
            redirectError = String.valueOf(response.getStatus());
            redirectErrorDescription = response.getError();
            redirectMessage = "";
        }
        response.setError((String)responseError);
        OM.LOG.error(response.getMessage() + RESPONSE_DASH + response.getError());
        if (openIDConfigForRepository.isPresent()) {
            try {
                Object authenticationFailURL = this.getRedirectURL("/auth/fail", openIDConfigForRepository);
                authenticationFailURL = (String)authenticationFailURL + "?message=" + openIDConfigForRepository.get().getEncodedURL(redirectMessage);
                authenticationFailURL = (String)authenticationFailURL + "&error=" + openIDConfigForRepository.get().getEncodedURL(redirectError);
                authenticationFailURL = (String)authenticationFailURL + "&error_description=" + openIDConfigForRepository.get().getEncodedURL(redirectErrorDescription);
                authenticationFailURL = (String)authenticationFailURL + "&error_uri=" + openIDConfigForRepository.get().getEncodedURL(redirectErrorURI);
                JsonBodyWriter.logError((Object)response, (String)remoteUser, (String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j");
                resp.sendRedirect((String)authenticationFailURL);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sendErrorResponse(resp, response, remoteUser);
    }

    private String getRedirectURL(String alias, Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository) {
        String webServerUrl;
        if (openIDConfigForRepository.isPresent() && (webServerUrl = openIDConfigForRepository.get().getImplicitFlowWebServerURL()) != null && !webServerUrl.isEmpty()) {
            return webServerUrl + alias;
        }
        return alias;
    }
}

