/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.jwt;

import com.google.gson.Gson;
import fr.obeo.dsl.viewpoint.collab.common.internal.jwt.AbstractJWTHelper;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.user.ImplicitFlowUserAuthenticationRegistry;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.MissingClaimException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.net4j.util.StringUtil;

public abstract class AbstractServerJWTHelper
extends AbstractJWTHelper {
    private static final String SCOPE_CLAIM = "scope";
    private String repositoryName;
    private OpenIDAuthenticatorConfig openIDConfigForRepository;

    public AbstractServerJWTHelper(String repositoryName, OpenIDAuthenticatorConfig openIDConfigForRepository) {
        this.repositoryName = repositoryName;
        this.openIDConfigForRepository = openIDConfigForRepository;
    }

    protected boolean postValidateAuthorization(Jwt<? extends Header, Claims> idToken, Jwt<? extends Header, Claims> accessToken, String userInfoResponse) {
        return this.checkRepository(idToken, accessToken, userInfoResponse);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkRepository(Jwt<?, ?> idToken, Jwt<?, ?> accessToken, String userInfoEndpointResponse) {
        String repositoryFilterPayload = this.getRepositoryFilterPayload();
        String repositoryFilterMatchClaim = this.openIDConfigForRepository.getRepositoryFilterMatchClaim();
        if (StringUtil.isEmpty((String)repositoryFilterPayload)) {
            return true;
        }
        boolean accessGrantedToRepo = false;
        if ("id_token".equals(repositoryFilterPayload)) {
            if (idToken == null) throw new UnsupportedJwtException("Expecting Claims payload for IdToken");
            Object object = idToken.getPayload();
            if (!(object instanceof Claims)) throw new UnsupportedJwtException("Expecting Claims payload for IdToken");
            Claims claims = (Claims)object;
            if (claims.containsKey((Object)repositoryFilterMatchClaim)) return this.checkRepositoryClaim(claims.get((Object)repositoryFilterMatchClaim));
            throw new MissingClaimException(idToken.getHeader(), claims, repositoryFilterMatchClaim, null, String.format("No \"%1$s\" claim in IdToken", repositoryFilterMatchClaim));
        }
        if ("access_token".equals(repositoryFilterPayload)) {
            if (accessToken == null) throw new UnsupportedJwtException("Expecting Claims payload for AccessToken");
            Object object = accessToken.getPayload();
            if (!(object instanceof Claims)) throw new UnsupportedJwtException("Expecting Claims payload for AccessToken");
            Claims claims = (Claims)object;
            this.checkScopeClaim(accessToken, repositoryFilterMatchClaim, claims);
            if (claims.containsKey((Object)repositoryFilterMatchClaim)) return this.checkRepositoryClaim(claims.get((Object)repositoryFilterMatchClaim));
            throw new MissingClaimException(accessToken.getHeader(), claims, repositoryFilterMatchClaim, null, String.format("No \"%1$s\" claim in AccessToken", repositoryFilterMatchClaim));
        }
        if (StringUtil.isEmpty((String)userInfoEndpointResponse)) throw new IllegalArgumentException(String.format("No /userInfo response provided to look for \"%1$s\" claim", repositoryFilterMatchClaim));
        Map claims = (Map)new Gson().fromJson(userInfoEndpointResponse, Map.class);
        if (claims.containsKey(repositoryFilterMatchClaim)) return this.checkRepositoryClaim(claims.get(repositoryFilterMatchClaim));
        throw new UnsupportedOperationException(String.format("Claim \"%1$s\" not found in the JSON response: %2$s", repositoryFilterMatchClaim, userInfoEndpointResponse));
    }

    private void checkScopeClaim(Jwt<?, ?> accessToken, String repositoryFilterMatchClaim, Claims claims) {
        if (!this.openIDConfigForRepository.isRepositoryFilterPayloadCheckScope()) {
            return;
        }
        if (!claims.containsKey((Object)SCOPE_CLAIM)) {
            throw new MissingClaimException(accessToken.getHeader(), claims, SCOPE_CLAIM, null, "No \"scope\" claim in AccessToken");
        }
        String scope = (String)claims.get((Object)SCOPE_CLAIM);
        if (!scope.contains(repositoryFilterMatchClaim)) {
            throw new IncorrectClaimException(accessToken.getHeader(), claims, SCOPE_CLAIM, (Object)scope, String.format("No \"%1$s\" scope in AccessToken", repositoryFilterMatchClaim));
        }
    }

    private boolean checkRepositoryClaim(Object repositoryClaim) {
        boolean userHasTargetRepositoryInClaims = false;
        Object expectedFilteredValue = this.repositoryName;
        if (!StringUtil.isEmpty((String)this.openIDConfigForRepository.getRepositoryFilterMatchValue())) {
            expectedFilteredValue = this.openIDConfigForRepository.getRepositoryFilterMatchValue();
        }
        if (!StringUtil.isEmpty((String)this.openIDConfigForRepository.getRepositoryFilterMatchPrefix())) {
            expectedFilteredValue = this.openIDConfigForRepository.getRepositoryFilterMatchPrefix() + (String)expectedFilteredValue;
        }
        if (repositoryClaim instanceof String) {
            String s = (String)repositoryClaim;
            userHasTargetRepositoryInClaims = ((String)expectedFilteredValue).equals(s);
        } else if (repositoryClaim instanceof Collection) {
            Collection c = (Collection)repositoryClaim;
            userHasTargetRepositoryInClaims = c.contains(expectedFilteredValue);
        }
        return userHasTargetRepositoryInClaims;
    }

    protected String getResponseType() {
        return this.openIDConfigForRepository.getResponseType();
    }

    protected String getIssuerURI() {
        return this.openIDConfigForRepository.getIssuerURI();
    }

    protected String getClientID() {
        return this.openIDConfigForRepository.getClientID();
    }

    protected String getJwksURI() {
        return this.openIDConfigForRepository.getJwksURI();
    }

    protected String getUserInfoEndPointURI() {
        return this.openIDConfigForRepository.getUserInfoEndPointURI();
    }

    protected String getUserInfoMatchClaim() {
        return this.openIDConfigForRepository.getUserInfoMatchClaim();
    }

    protected String getUserInfoPayload() {
        return this.openIDConfigForRepository.getUserInfoPayload();
    }

    protected String getAccessTokenAudience() {
        return this.openIDConfigForRepository.getAccessTokenAudience();
    }

    protected String getAcrValues() {
        return this.openIDConfigForRepository.getAcrValues();
    }

    protected void logError(String msg, Exception e) {
        OM.LOG.error(msg, (Throwable)e);
    }

    protected String getRepositoryFilterPayload() {
        return this.openIDConfigForRepository.getRepositoryFilterPayload();
    }

    protected ImplicitFlowUserAuthenticationRegistry getImplicitFlowUserAuthenticationRegistry() {
        return this.openIDConfigForRepository.getImplicitFlowUserAuthenticationRegistry();
    }
}

