/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.jetty.customizer;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.SecureStorageLoginService;
import fr.obeo.dsl.viewpoint.collab.server.admin.jetty.customizer.error.DefaultErrorHandler;
import java.util.Dictionary;
import javax.servlet.ServletRequest;
import org.eclipse.equinox.http.jetty.JettyCustomizer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.slf4j.LoggerFactory;

public class RestAdminJettyCustomizer
extends JettyCustomizer {
    private static final String REST_API_AUTHENTICATING_LOG_MESSAGE = "REST API - Authentication: '{}' for {}";
    private static final String REST_API_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE = "REST API - Authentication successful: '{}' for {}";
    private static final String REST_API_AUTHENTICATION_FAILED_LOG_MESSAGE = "REST API - Authentication failed: '{}' for {}";
    private static final String REST_ADMIN_REALM = "REST Admin Realm";

    public Object customizeContext(Object context, Dictionary<String, ?> settings) {
        if (context instanceof ServletContextHandler) {
            ServletContextHandler servletContext = (ServletContextHandler)context;
            servletContext.setSecurityHandler(this.createSecurityHandlerFromConfig());
            servletContext.setErrorHandler((ErrorHandler)new DefaultErrorHandler());
            JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)servletContext, null);
            Server server = ((ServletContextHandler)context).getServer();
            CustomRequestLog requestLog = new CustomRequestLog();
            server.setRequestLog((RequestLog)requestLog);
        }
        return context;
    }

    protected SecurityHandler createSecurityHandlerFromConfig() {
        HashLoginService loginService;
        AdminServerConfigurationHelper adminServerConfigHelper = AdminServerConfigurationHelper.getInstance();
        if (Boolean.getBoolean("fr.obeo.dsl.viewpoint.collab.server.admin.jetty.realm.file")) {
            loginService = new HashLoginService(REST_ADMIN_REALM, adminServerConfigHelper.getRealmPropertiesFilePath()){

                public UserIdentity login(String username, Object credentials, ServletRequest request) {
                    LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.rest.admin").info(RestAdminJettyCustomizer.REST_API_AUTHENTICATING_LOG_MESSAGE, (Object)username, (Object)request);
                    UserIdentity login = super.login(username, credentials, request);
                    if (login == null) {
                        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.rest.admin").error(RestAdminJettyCustomizer.REST_API_AUTHENTICATION_FAILED_LOG_MESSAGE, (Object)username, (Object)request);
                    } else {
                        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.rest.admin").trace(RestAdminJettyCustomizer.REST_API_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE, (Object)username, (Object)request);
                    }
                    return login;
                }
            };
        } else {
            int httpPort = adminServerConfigHelper.isHttpsEnabled() ? adminServerConfigHelper.getHttpsPort() : adminServerConfigHelper.getHttpPort();
            loginService = new SecureStorageLoginService(adminServerConfigHelper.getAdminServerConfigurationPath(), httpPort);
        }
        Constraint adminConstraint = new Constraint();
        adminConstraint.setName("BASIC");
        adminConstraint.setRoles(new String[]{"admin"});
        adminConstraint.setAuthenticate(true);
        ConstraintMapping adminConstraintMapping = new ConstraintMapping();
        adminConstraintMapping.setConstraint(adminConstraint);
        adminConstraintMapping.setPathSpec("/*");
        Constraint publicConstraint = new Constraint();
        publicConstraint.setAuthenticate(false);
        publicConstraint.setRoles(new String[0]);
        ConstraintMapping docConstraintMapping = new ConstraintMapping();
        docConstraintMapping.setConstraint(publicConstraint);
        docConstraintMapping.setPathSpec("/doc/*");
        ConstraintMapping monitoringConstraintMapping = new ConstraintMapping();
        monitoringConstraintMapping.setConstraint(publicConstraint);
        monitoringConstraintMapping.setPathSpec("/monitoring/*");
        ConstraintMapping apiConstraintMapping = new ConstraintMapping();
        apiConstraintMapping.setConstraint(publicConstraint);
        apiConstraintMapping.setPathSpec("/openapi/*");
        ConstraintMapping net4jWebSocketMapping = new ConstraintMapping();
        net4jWebSocketMapping.setConstraint(publicConstraint);
        net4jWebSocketMapping.setPathSpec("/net4j/*");
        ConstraintMapping openIDSocketMapping = new ConstraintMapping();
        openIDSocketMapping.setConstraint(publicConstraint);
        openIDSocketMapping.setPathSpec("/auth/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName(REST_ADMIN_REALM);
        csh.addConstraintMapping(adminConstraintMapping);
        csh.addConstraintMapping(docConstraintMapping);
        csh.addConstraintMapping(monitoringConstraintMapping);
        csh.addConstraintMapping(apiConstraintMapping);
        csh.addConstraintMapping(openIDSocketMapping);
        if (!AdminServerConfigurationHelper.getInstance().removePublicConstraintFromNet4JServlet()) {
            csh.addConstraintMapping(net4jWebSocketMapping);
        }
        csh.setLoginService((LoginService)loginService);
        return csh;
    }
}

