/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.ILockingManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.concurrent.Access;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.IRWOLockManager;
import org.eclipse.net4j.util.concurrent.RWOLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.options.IOptionsContainer;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public class LockingManager
extends RWOLockManager<Object, IView>
implements InternalLockManager {
    private static final IRWLockManager.LockType[] ALL_LOCK_TYPES = IRWLockManager.LockType.values();
    private InternalRepository repository;
    private Map<String, InternalView> openDurableViews = new HashMap<String, InternalView>();
    private Map<String, DurableView> durableViews = Collections.synchronizedMap(new HashMap());
    private ConcurrentArray<ILockingManager.DurableViewHandler> durableViewHandlers = new ConcurrentArray<ILockingManager.DurableViewHandler>(){

        protected ILockingManager.DurableViewHandler[] newArray(int length) {
            return new ILockingManager.DurableViewHandler[length];
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient IListener sessionManagerListener = new ContainerEventAdapter<ISession>(){

        protected void onAdded(IContainer<ISession> container, ISession session) {
            session.addListener(LockingManager.this.sessionListener);
        }

        protected void onRemoved(IContainer<ISession> container, ISession session) {
            session.removeListener(LockingManager.this.sessionListener);
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient IListener sessionListener = new ContainerEventAdapter<IView>(){

        protected void onRemoved(IContainer<IView> container, IView view) {
            String durableLockingID = view.getDurableLockingID();
            if (durableLockingID == null) {
                LockingManager.this.repository.unlock((InternalView)view);
            } else {
                DurableView durableView = new DurableView(durableLockingID, (CDOBranchPoint)view, view.isReadOnly());
                LockingManager.this.changeContext(view, durableView);
                LockingManager.this.unregisterOpenDurableView(durableLockingID, false);
                LockingManager.this.durableViews.put(durableLockingID, durableView);
            }
        }
    };
    private BiFunction<CDOID, CDOBranch, Object> lockKeyCreator;
    private Function<Object, CDOID> lockIDExtractor;
    private Function<Object, CDOBranch> lockBranchExtractor;

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.repository = repository;
    }

    @Override
    public Object getLockKey(CDOID id, CDOBranch branch) {
        return this.lockKeyCreator.apply(id, branch);
    }

    @Override
    public CDOID getLockKeyID(Object key) {
        return this.lockIDExtractor.apply(key);
    }

    @Override
    public CDOBranch getLockKeyBranch(Object key) {
        return this.lockBranchExtractor.apply(key);
    }

    @Override
    public Map<CDOID, IDurableLockingManager.LockGrade> getLocks(IView view) {
        Map result = CDOIDUtil.createMap();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Access access = this.read.access();){
            for (RWOLockManager.LockState lockState : this.getObjectToLocksMap().values()) {
                IDurableLockingManager.LockGrade grade = IDurableLockingManager.LockGrade.NONE;
                if (lockState.hasLock(IRWLockManager.LockType.READ, (Object)view, false)) {
                    grade = grade.getUpdated(IRWLockManager.LockType.READ, true);
                }
                if (lockState.hasLock(IRWLockManager.LockType.WRITE, (Object)view, false)) {
                    grade = grade.getUpdated(IRWLockManager.LockType.WRITE, true);
                }
                if (lockState.hasLock(IRWLockManager.LockType.OPTION, (Object)view, false)) {
                    grade = grade.getUpdated(IRWLockManager.LockType.OPTION, true);
                }
                if (grade == IDurableLockingManager.LockGrade.NONE) continue;
                CDOID id = this.getLockKeyID(lockState.getLockedObject());
                result.put(id, grade);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private Set<? extends Object> createContentSet(Collection<? extends Object> objectsToLock, IView view) {
        CDOBranch branch = view.getBranch();
        CDORevisionManager revisionManager = view.getSession().getRepository().getRevisionManager();
        ManagedRevisionProvider revisionProvider = new ManagedRevisionProvider(revisionManager, branch.getHead());
        HashSet<Object> contents = new HashSet<Object>();
        for (Object object : objectsToLock) {
            contents.add(object);
            CDOID id = this.getLockKeyID(object);
            CDORevision revision = revisionProvider.getRevision(id);
            this.createContentSet(branch, (CDORevisionProvider)revisionProvider, revision, contents);
        }
        return contents;
    }

    private void createContentSet(CDOBranch branch, CDORevisionProvider revisionProvider, CDORevision revision, Set<Object> contents) {
        for (CDORevision child : CDORevisionUtil.getChildRevisions((CDORevision)revision, (CDORevisionProvider)revisionProvider)) {
            CDOID childID = child.getID();
            Object key = this.getLockKey(childID, branch);
            contents.add(key);
            this.createContentSet(branch, revisionProvider, child, contents);
        }
    }

    @Override
    public long lock(IView view, Collection<? extends Object> objects, IRWLockManager.LockType lockType, int count, long timeout, boolean recursive, boolean explicit, IRWOLockManager.LockDeltaHandler<Object, IView> deltaHandler, Consumer<RWOLockManager.LockState<Object, IView>> stateHandler) throws InterruptedException, TimeoutRuntimeException {
        long modCount;
        Throwable throwable = null;
        Object var14_13 = null;
        try (Access access = this.write.access();){
            if (recursive) {
                objects = this.createContentSet(objects, view);
            }
            modCount = super.lock((Object)view, objects, lockType, count, timeout, deltaHandler, stateHandler);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (explicit) {
            try {
                this.lockDurably(view, objects, lockType);
            }
            catch (Error | Exception ex) {
                super.unlock((Object)view, objects, lockType, count, null, null);
                throw ex;
            }
        }
        return modCount;
    }

    private void lockDurably(IView view, Collection<? extends Object> objects, IRWLockManager.LockType lockType) {
        String durableLockingID = view.getDurableLockingID();
        if (durableLockingID != null) {
            IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
            accessor.lock(durableLockingID, lockType, objects);
        }
    }

    @Override
    public long unlock(IView view, Collection<? extends Object> objects, IRWLockManager.LockType lockType, int count, boolean recursive, boolean explicit, IRWOLockManager.LockDeltaHandler<Object, IView> deltaHandler, Consumer<RWOLockManager.LockState<Object, IView>> stateHandler) {
        long modCount;
        Throwable throwable = null;
        Object var12_11 = null;
        try (Access access = this.write.access();){
            if (recursive) {
                objects = this.createContentSet(objects, view);
            }
            modCount = super.unlock((Object)view, objects, lockType, count, deltaHandler, stateHandler);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (explicit) {
            this.unlockDurably(view, objects, lockType);
        }
        return modCount;
    }

    private void unlockDurably(IView view, Collection<? extends Object> objects, IRWLockManager.LockType lockType) {
        String durableLockingID = view.getDurableLockingID();
        if (durableLockingID != null) {
            IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
            accessor.unlock(durableLockingID, lockType, objects);
        }
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return this.createLockArea(userID, branchPoint, readOnly, locks, null);
    }

    private IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks, String lockAreaID) {
        if (lockAreaID == null) {
            IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
            return accessor.createLockArea(userID, branchPoint, readOnly, locks);
        }
        IStoreAccessor.DurableLocking2 accessor = this.getDurableLocking2();
        return accessor.createLockArea(lockAreaID, userID, branchPoint, readOnly, locks);
    }

    @Override
    public IDurableLockingManager.LockArea createLockArea(InternalView view) {
        return this.createLockArea(view, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDurableLockingManager.LockArea createLockArea(InternalView view, String lockAreaID) {
        String userID = view.getSession().getUserID();
        CDOBranchPoint branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)view);
        boolean readOnly = view.isReadOnly();
        Map<CDOID, IDurableLockingManager.LockGrade> locks = this.getLocks(view);
        IDurableLockingManager.LockArea area = this.createLockArea(userID, branchPoint, readOnly, locks, lockAreaID);
        Map<String, InternalView> map = this.openDurableViews;
        synchronized (map) {
            this.openDurableViews.put(area.getDurableLockingID(), view);
        }
        return area;
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        return accessor.getLockArea(durableLockingID);
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        if (userIDPrefix == null) {
            userIDPrefix = "";
        }
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        accessor.getLockAreas(userIDPrefix, handler);
    }

    public void deleteLockArea(String durableLockingID) {
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        accessor.deleteLockArea(durableLockingID);
        this.unregisterOpenDurableView(durableLockingID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openView(ISession session, int viewID, boolean readOnly, final String durableLockingID, Consumer<IView> viewConsumer, BiConsumer<CDOID, IDurableLockingManager.LockGrade> lockConsumer) {
        Map<String, InternalView> map = this.openDurableViews;
        synchronized (map) {
            InternalView view = this.openDurableViews.get(durableLockingID);
            if (view != null) {
                throw new IllegalStateException("Durable view is already open: " + view);
            }
            IDurableLockingManager.LockArea area = this.getLockArea(durableLockingID);
            if (area.isReadOnly() != readOnly) {
                throw new IllegalStateException("Durable read-only state does not match the request");
            }
            ILockingManager.DurableViewHandler[] durableViewHandlerArray = (ILockingManager.DurableViewHandler[])this.durableViewHandlers.get();
            int n = durableViewHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILockingManager.DurableViewHandler handler = durableViewHandlerArray[n2];
                try {
                    handler.openingView(session, viewID, readOnly, area);
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
                ++n2;
            }
            view = readOnly ? (InternalView)session.openView(viewID, (CDOBranchPoint)area, durableLockingID) : (InternalView)((Object)session.openTransaction(viewID, (CDOBranchPoint)area, durableLockingID));
            DurableView durableView = this.durableViews.get(durableLockingID);
            this.changeContext(durableView, view);
            view.addListener((IListener)new LifecycleEventAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onDeactivated(ILifecycle lifecycle) {
                    Map map = LockingManager.this.openDurableViews;
                    synchronized (map) {
                        LockingManager.this.openDurableViews.remove(durableLockingID);
                    }
                }
            });
            this.openDurableViews.put(durableLockingID, view);
            viewConsumer.accept(view);
            if (lockConsumer != null) {
                for (Map.Entry entry : area.getLocks().entrySet()) {
                    CDOID id = (CDOID)entry.getKey();
                    IDurableLockingManager.LockGrade lockGrade = (IDurableLockingManager.LockGrade)entry.getValue();
                    lockConsumer.accept(id, lockGrade);
                }
            }
        }
    }

    protected void changeContext(IView oldContext, IView newContext) {
        CDOBranch branch;
        super.changeContext((Object)oldContext, (Object)newContext);
        InternalSession session = (InternalSession)oldContext.getSession();
        if (session == null) {
            session = (InternalSession)newContext.getSession();
        }
        if ((branch = oldContext.getBranch()) == null) {
            branch = newContext.getBranch();
        }
        CDOLockOwner oldOwner = oldContext.getLockOwner();
        CDOLockOwner newOwner = newContext.getLockOwner();
        this.repository.getSessionManager().sendLockOwnerRemappedNotification(session, branch, oldOwner, newOwner);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.repository.isSupportingBranches()) {
            this.lockKeyCreator = (id, branch) -> CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)branch);
            this.lockIDExtractor = key -> ((CDOIDAndBranch)key).getID();
            this.lockBranchExtractor = key -> ((CDOIDAndBranch)key).getBranch();
        } else {
            InternalCDOBranch mainBranch = this.repository.getBranchManager().getMainBranch();
            this.lockKeyCreator = (id, branch) -> id;
            this.lockIDExtractor = key -> (CDOID)key;
            this.lockBranchExtractor = key -> mainBranch;
        }
        this.loadLocks();
        InternalSessionManager sessionManager = this.repository.getSessionManager();
        sessionManager.addListener(this.sessionManagerListener);
        InternalSession[] internalSessionArray = sessionManager.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            session.addListener(this.sessionListener);
            ++n2;
        }
    }

    protected void doDeactivate() throws Exception {
        InternalSessionManager sessionManager = this.repository.getSessionManager();
        sessionManager.removeListener(this.sessionManagerListener);
        ISession[] iSessionArray = sessionManager.getSessions();
        int n = iSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISession session = iSessionArray[n2];
            session.removeListener(this.sessionListener);
            ++n2;
        }
        super.doDeactivate();
    }

    private IStoreAccessor.DurableLocking getDurableLocking() {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (accessor instanceof IStoreAccessor.DurableLocking) {
            return (IStoreAccessor.DurableLocking)((Object)accessor);
        }
        throw new IllegalStateException("Store does not implement " + IStoreAccessor.DurableLocking.class.getSimpleName());
    }

    private IStoreAccessor.DurableLocking2 getDurableLocking2() {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (accessor instanceof IStoreAccessor.DurableLocking2) {
            return (IStoreAccessor.DurableLocking2)((Object)accessor);
        }
        throw new IllegalStateException("Store does not implement " + IStoreAccessor.DurableLocking2.class.getSimpleName());
    }

    @Override
    public void reloadLocks() {
        DurableLockLoader handler = new DurableLockLoader();
        this.getLockAreas(null, handler);
    }

    private void loadLocks() {
        InternalStore store = this.repository.getStore();
        IStoreAccessor reader = null;
        try {
            reader = store.getReader(null);
            if (reader instanceof IStoreAccessor.DurableLocking) {
                StoreThreadLocal.setAccessor(reader);
                this.reloadLocks();
            }
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterOpenDurableView(String durableLockingID, boolean notifyOtherSessions) {
        CDOLockOwner newOwner;
        InternalView view;
        CDOLockOwner oldOwner = null;
        Map<String, InternalView> map = this.openDurableViews;
        synchronized (map) {
            view = this.openDurableViews.remove(durableLockingID);
            if (view != null) {
                oldOwner = view.getLockOwner();
                view.setDurableLockingID(null);
            }
        }
        if (notifyOtherSessions && view != null && (newOwner = view.getLockOwner()) != oldOwner) {
            CDOBranch branch = view.getBranch();
            InternalSession session = view.getSession();
            InternalSessionManager manager = session.getManager();
            manager.sendLockOwnerRemappedNotification(session, branch, oldOwner, newOwner);
        }
    }

    @Override
    public void addDurableViewHandler(ILockingManager.DurableViewHandler handler) {
        this.durableViewHandlers.add((Object)handler);
    }

    @Override
    public void removeDurableViewHandler(ILockingManager.DurableViewHandler handler) {
        this.durableViewHandlers.remove((Object)handler);
    }

    @Override
    public ILockingManager.DurableViewHandler[] getDurableViewHandlers() {
        return (ILockingManager.DurableViewHandler[])this.durableViewHandlers.get();
    }

    @Override
    public IDurableLockingManager.LockGrade getLockGrade(Object key) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Access access = this.read.access();){
            RWOLockManager.LockState lockState = (RWOLockManager.LockState)this.getObjectToLocksMap().get(key);
            IDurableLockingManager.LockGrade grade = IDurableLockingManager.LockGrade.NONE;
            if (lockState != null) {
                IRWLockManager.LockType[] lockTypeArray = ALL_LOCK_TYPES;
                int n = ALL_LOCK_TYPES.length;
                int n2 = 0;
                while (n2 < n) {
                    IRWLockManager.LockType type = lockTypeArray[n2];
                    if (lockState.hasLock(type)) {
                        grade = grade.getUpdated(type, true);
                    }
                    ++n2;
                }
            }
            return grade;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IDurableLockingManager.LockArea getLockAreaNoEx(String durableLockingID) {
        try {
            return this.getLockArea(durableLockingID);
        }
        catch (IDurableLockingManager.LockAreaNotFoundException e) {
            return null;
        }
    }

    @Override
    public void updateLockArea(IDurableLockingManager.LockArea lockArea) {
        String durableLockingID = lockArea.getDurableLockingID();
        IStoreAccessor.DurableLocking2 accessor = this.getDurableLocking2();
        if (lockArea.isMissing()) {
            IDurableLockingManager.LockArea localLockArea = this.getLockAreaNoEx(durableLockingID);
            if (localLockArea != null && localLockArea.getLocks().size() > 0) {
                accessor.deleteLockArea(durableLockingID);
                DurableView deletedView = this.durableViews.remove(durableLockingID);
                CheckUtil.checkNull((Object)deletedView, (String)"deletedView");
            }
        } else {
            accessor.updateLockArea(lockArea);
            new DurableLockLoader().handleLockArea(lockArea);
        }
    }

    @Override
    @Deprecated
    public Object getLockEntryObject(Object key) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Access access = this.read.access();){
            RWOLockManager.LockState lockState = (RWOLockManager.LockState)this.getObjectToLocksMap().get(key);
            Object object = lockState == null ? null : lockState.getLockedObject();
            return object;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public void lock(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToLock, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unlock(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unlock(boolean explicit, IView view) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void lock(IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToLock, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void lock(IRWLockManager.LockType type, IView view, Object objectToLock, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RWOLockManager.LockState<Object, IView>> lock2(IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToLock, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RWOLockManager.LockState<Object, IView>> lock2(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToLock, boolean recursive, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unlock(IView view) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unlock(IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RWOLockManager.LockState<Object, IView>> unlock2(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objects, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RWOLockManager.LockState<Object, IView>> unlock2(boolean explicit, IView view) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RWOLockManager.LockState<Object, IView>> unlock2(IView view) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RWOLockManager.LockState<Object, IView>> unlock2(IView view, Collection<? extends Object> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<RWOLockManager.LockState<Object, IView>> unlock2(IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public IView openView(ISession session, int viewID, boolean readOnly, String durableLockingID) {
        throw new UnsupportedOperationException();
    }

    private final class DurableLockLoader
    implements IDurableLockingManager.LockArea.Handler {
        private IView getView(String lockAreaID) {
            IView view = (IView)LockingManager.this.openDurableViews.get(lockAreaID);
            if (view == null) {
                view = (IView)LockingManager.this.durableViews.get(lockAreaID);
            }
            return view;
        }

        public boolean handleLockArea(IDurableLockingManager.LockArea area) {
            String durableLockingID = area.getDurableLockingID();
            IView view = this.getView(durableLockingID);
            if (view != null) {
                LockingManager.super.unlock(view, null, null, -1, null, null);
            } else {
                view = new DurableView(durableLockingID, (CDOBranchPoint)area, area.isReadOnly());
                LockingManager.this.durableViews.put(durableLockingID, (DurableView)view);
            }
            ArrayList<Object> readLocks = new ArrayList<Object>();
            ArrayList<Object> writeLocks = new ArrayList<Object>();
            ArrayList<Object> writeOptions = new ArrayList<Object>();
            for (Map.Entry entry : area.getLocks().entrySet()) {
                Object key = LockingManager.this.getLockKey((CDOID)entry.getKey(), area.getBranch());
                IDurableLockingManager.LockGrade grade = (IDurableLockingManager.LockGrade)entry.getValue();
                if (grade.isRead()) {
                    readLocks.add(key);
                }
                if (grade.isWrite()) {
                    writeLocks.add(key);
                }
                if (!grade.isOption()) continue;
                writeOptions.add(key);
            }
            try {
                LockingManager.super.lock(view, readLocks, IRWLockManager.LockType.READ, 1, 1000L, null, null);
                LockingManager.super.lock(view, writeLocks, IRWLockManager.LockType.WRITE, 1, 1000L, null, null);
                LockingManager.super.lock(view, writeOptions, IRWLockManager.LockType.OPTION, 1, 1000L, null, null);
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            return true;
        }
    }

    private final class DurableView
    extends PlatformObject
    implements IView,
    CDOCommonView.Options {
        private final String durableLockingID;
        private final CDOBranchPoint branchPoint;
        private final boolean readOnly;
        private final CDOLockOwner lockOwner;
        private IRegistry<String, Object> properties;

        public DurableView(String durableLockingID, CDOBranchPoint branchPoint, boolean readOnly) {
            this.durableLockingID = durableLockingID;
            this.readOnly = readOnly;
            this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)branchPoint);
            this.lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
        }

        public String getDurableLockingID() {
            return this.durableLockingID;
        }

        public boolean isDurableView() {
            return true;
        }

        public CDOLockOwner getLockOwner() {
            return this.lockOwner;
        }

        public int getSessionID() {
            return 0;
        }

        public int getViewID() {
            return 0;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public boolean isHistorical() {
            return this.branchPoint.getTimeStamp() != 0L;
        }

        public CDOBranch getBranch() {
            return this.branchPoint.getBranch();
        }

        public long getTimeStamp() {
            return this.branchPoint.getTimeStamp();
        }

        public CDORevision getRevision(CDOID id) {
            CDORevisionManager revisionManager = this.getRepository().getRevisionManager();
            return revisionManager.getRevision(id, this.branchPoint, -1, 0, true);
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public boolean isClosed() {
            return false;
        }

        @Override
        public IRepository getRepository() {
            return LockingManager.this.getRepository();
        }

        @Override
        public ISession getSession() {
            return null;
        }

        public int hashCode() {
            return this.durableLockingID.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DurableView) {
                DurableView that = (DurableView)obj;
                return this.durableLockingID.equals(that.getDurableLockingID());
            }
            return false;
        }

        public String toString() {
            return MessageFormat.format("DurableView[0:0:{0}]", this.durableLockingID);
        }

        public IOptionsContainer getContainer() {
            return this;
        }

        public void addListener(IListener listener) {
        }

        public void removeListener(IListener listener) {
        }

        public boolean hasListeners() {
            return false;
        }

        public IListener[] getListeners() {
            return EventUtil.NO_LISTENERS;
        }

        public CDOCommonView.Options options() {
            return this;
        }

        public synchronized IRegistry<String, Object> properties() {
            if (this.properties == null) {
                this.properties = new HashMapRegistry.AutoCommit();
            }
            return this.properties;
        }

        public boolean isLockNotificationEnabled() {
            return false;
        }

        public void setLockNotificationEnabled(boolean enabled) {
        }
    }

    public static final class LockDeltaCollector
    extends ArrayList<CDOLockDelta>
    implements IRWOLockManager.LockDeltaHandler<Object, IView> {
        private static final long serialVersionUID = 1L;
        private CDOLockChangeInfo.Operation operation;

        public LockDeltaCollector(CDOLockChangeInfo.Operation operation) {
            this.operation = operation;
        }

        public LockDeltaCollector() {
        }

        public CDOLockChangeInfo.Operation getOperation() {
            return this.operation;
        }

        public void setOperation(CDOLockChangeInfo.Operation operation) {
            this.operation = operation;
        }

        public void handleLockDelta(IView context, Object object, IRWLockManager.LockType lockType, int oldCount, int newCount) {
            switch (this.operation) {
                case LOCK: {
                    if (oldCount != 0 || newCount <= 0) break;
                    CDOLockOwner lockOwner = context.getLockOwner();
                    CDOLockDelta lockDelta = CDOLockUtil.createLockDelta((Object)object, (IRWLockManager.LockType)lockType, null, (CDOLockOwner)lockOwner);
                    this.add(lockDelta);
                    break;
                }
                case UNLOCK: {
                    if (oldCount <= 0 || newCount != 0) break;
                    CDOLockOwner lockOwner = context.getLockOwner();
                    CDOLockDelta lockDelta = CDOLockUtil.createLockDelta((Object)object, (IRWLockManager.LockType)lockType, (CDOLockOwner)lockOwner, null);
                    this.add(lockDelta);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    public static final class LockStateCollector
    extends ArrayList<CDOLockState>
    implements Consumer<RWOLockManager.LockState<Object, IView>> {
        private static final long serialVersionUID = 1L;

        @Override
        public void accept(RWOLockManager.LockState<Object, IView> serverLockState) {
            CDOLockState commonLockState = CDOLockUtil.convertLockState(serverLockState);
            this.add(commonLockState);
        }
    }
}

