/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api;

import fr.obeo.dsl.viewpoint.collab.common.internal.helper.CollabConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public final class AdminServerConfigurationHelper {
    public static final String JETTY_HTTPS_ENABLED = "admin.server.jetty.https.enabled";
    public static final String JETTY_HTTPS_HOST = "admin.server.jetty.ssl.host";
    public static final String JETTY_HTTPS_PORT = "admin.server.jetty.ssl.port";
    public static final String JETTY_SSL_KEYSTORE_PATH = "admin.server.jetty.ssl.keystore.path";
    public static final String JETTY_SSL_KEYSTORE_PASSPHRASE = "admin.server.jetty.ssl.keystore.passphrase";
    public static final String JETTY_SSL_KEY_PASSWORD = "admin.server.jetty.ssl.keypassword";
    public static final String JETTY_HTTP_ENABLE = "admin.server.jetty.http.enabled";
    public static final String JETTY_HTTP_HOST = "admin.server.jetty.http.host";
    public static final String JETTY_HTTP_PORT = "admin.server.jetty.port";
    public static final String REPOSITORIES_DIRECTORY_PATH = "admin.server.repositories.directory.path";
    public static final String REPOSITORIES_EXPORT_DIRECTORY_PATH = "admin.server.repositories.export.directory.path";
    public static final String OPENAPI_DIRECTORY_PATH = "admin.server.openapi.directory.path";
    public static final String DOC_DIRECTORY_PATH = "admin.server.doc.directory.path";
    public static final String REPOSITORIES_EXPORT_DIRECTORY_FILESERVER_ALLOW_DIRECTORY = "admin.server.repositories.export.directory.fileserver.allow.directory";
    public static final String LDAP_TRUSTSTORE_PATH = "admin.server.ldap.truststore.path";
    public static final String ADMIN_SERVER_CONFIGURATION_PATH = "admin.server.configuration.path";
    public static final String ADMIN_SERVER_JETTY_ADMIN_SERVLETS_ENABLED = "admin.server.jetty.admin.servlets.enabled";
    public static final Object ADMIN_SERVER_JETTY_ADMIN_DOC_OPENAPI_SERVLETS_ENABLED = "admin.server.jetty.servlets.admin.docandopenapi.enabled";
    public static final String ADMIN_SERVER_JETTY_NET4J_ENABLED = "admin.server.jetty.net4j.enabled";
    public static final String ADMIN_SERVER_JETTY_NET4J_PATH = "admin.server.jetty.net4j.path";
    public static final String ADMIN_SERVER_JETTY_NET4J_REMOVE_PUBLIC_CONSTRAINT = "admin.server.jetty.net4j.remove.public.constraint";
    public static final String ADMIN_SERVER_API_PROJECT_GET_ENABLED = "admin.server.api.project.get.enabled";
    public static final String ADMIN_SERVER_API_PROJECT_POST_ENABLED = "admin.server.api.project.post.enabled";
    public static final String GET_CONFIG_PREFIX = "admin.server.api.project.get.impl.config";
    public static final String POST_CONFIG_PREFIX = "admin.server.api.project.post.impl.config";
    public static final String ADMIN_SERVER_API_PROJECT_DELETE_ENABLED = "admin.server.api.project.delete.enabled";
    public static final String ADMIN_SERVER_LOCAL_CLIENT_LOGS_DIRECTORY_PATH = "admin.server.local.client.logs.directory.path";
    private static final String CURRENT_PATH = ".";
    private static final String DEFAULT_REPOSITORIES_DIRECTORY_PATH = ".";
    private static final String DEFAULT_REPOSITORIES_EXPORT_DIRECTORY_PATH = ".";
    private static final String DEFAULT_ADMIN_SERVER_CONFIGURATION_DIRECTORY_NAME = "fr.obeo.dsl.viewpoint.collab.server.admin";
    private static final String ADMIN_SERVER_PROPERTIES_FILE_NAME = "admin-server.properties";
    private static final String REALM_PROPERTIES_FILE_NAME = "realm.properties";
    private static final String DEFAULT_HTTP_HOST = "0.0.0.0";
    private static final String DEFAULT_HTTPS_HOST = "0.0.0.0";
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final int DEFAULT_HTTP_PORT = 8080;
    private static final String CURRENT_DIRECTORY_PATTERN = "${currentDir}";
    private static final String READ_PROPERTIES_FILE_ERROR = "The %1$s server will not start because an error occurred during the load of the %2$s file";
    private static final String EMPTY_PROPERTIES_FILE_ERROR = "The %1$s server will not start because the %2$s file is present but empty.";
    private Properties configurationProperties;
    private String administrationServerConfigurationDirectoryPath;

    private AdminServerConfigurationHelper() {
        this.initialize();
    }

    private void initialize() {
        if (this.configurationProperties == null) {
            String propertiesPathString = this.getAdminServerConfigurationPath();
            java.nio.file.Path propertiesPath = Paths.get(propertiesPathString, ADMIN_SERVER_PROPERTIES_FILE_NAME);
            Properties properties = new Properties();
            try {
                Throwable throwable = null;
                Iterator<Map.Entry<Object, Object>> iterator = null;
                try (FileInputStream fileInputStream = new FileInputStream(propertiesPath.toString());){
                    properties.load(fileInputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                OM.LOG.error("An error occurred during the load of the configuration properties file", (Throwable)e);
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String propertyString;
                Object value = entry.getValue();
                if (!(value instanceof String) || !(propertyString = value.toString()).startsWith(CURRENT_DIRECTORY_PATTERN)) continue;
                entry.setValue(this.removeLastSeparatorIfPresent(propertiesPathString) + propertyString.substring(CURRENT_DIRECTORY_PATTERN.length()));
            }
            this.configurationProperties = properties;
        }
    }

    public String getAdminServerConfigurationPath() {
        if (this.administrationServerConfigurationDirectoryPath == null) {
            this.administrationServerConfigurationDirectoryPath = this.computeAdministrationServerConfigurationDirectoryPath();
        }
        return this.administrationServerConfigurationDirectoryPath;
    }

    private String computeAdministrationServerConfigurationDirectoryPath() {
        String propertiesPathString = System.getProperty(ADMIN_SERVER_CONFIGURATION_PATH);
        if (propertiesPathString == null) {
            File defaultAdminDirectory;
            if (!this.hasConfigurationFolder()) {
                defaultAdminDirectory = Paths.get(".", DEFAULT_ADMIN_SERVER_CONFIGURATION_DIRECTORY_NAME).toFile();
                OM.LOG.warn(String.format("The platform is running without a configuration location. Fallback to %1$s directory", defaultAdminDirectory.getPath()));
            } else {
                defaultAdminDirectory = new File(Platform.getConfigurationLocation().getURL().getFile(), DEFAULT_ADMIN_SERVER_CONFIGURATION_DIRECTORY_NAME);
            }
            defaultAdminDirectory.mkdirs();
            propertiesPathString = defaultAdminDirectory.getAbsolutePath();
        }
        return propertiesPathString;
    }

    private boolean hasConfigurationFolder() {
        boolean hasConfigurationFolder = true;
        Location location = Platform.getConfigurationLocation();
        if (location == null) {
            return false;
        }
        URL configUrl = location.getURL();
        if (configUrl == null || !configUrl.getProtocol().startsWith("file")) {
            hasConfigurationFolder = false;
        }
        return hasConfigurationFolder;
    }

    public static AdminServerConfigurationHelper getInstance() {
        return AdminServerConfigurationHelperHolder.INSTANCE;
    }

    private String removeLastSeparatorIfPresent(String propertiesPath) {
        if (propertiesPath.endsWith("/") || propertiesPath.endsWith("\\")) {
            return propertiesPath.substring(0, propertiesPath.length() - 1);
        }
        return propertiesPath;
    }

    public boolean isHttpsEnabled() {
        Object object = this.configurationProperties.get(JETTY_HTTPS_ENABLED);
        return CommonUtil.getBoolean(object, Boolean.FALSE);
    }

    public String getHttpsHost() {
        Object object = this.configurationProperties.get(JETTY_HTTPS_HOST);
        return CommonUtil.getString(object, "0.0.0.0");
    }

    public int getHttpsPort() {
        Object object = this.configurationProperties.get(JETTY_HTTPS_PORT);
        return CommonUtil.getInt(object, 443);
    }

    public String getKeystorePath() {
        Object object = this.configurationProperties.get(JETTY_SSL_KEYSTORE_PATH);
        return CommonUtil.getString(object, "");
    }

    public String getKeystorePassphrase() {
        Object object = this.configurationProperties.get(JETTY_SSL_KEYSTORE_PASSPHRASE);
        return CollabConfigurationHelper.getProperty((String)JETTY_SSL_KEYSTORE_PASSPHRASE, (String)CommonUtil.getString(object, ""));
    }

    public String getKeyPassword() {
        Object object = this.configurationProperties.get(JETTY_SSL_KEY_PASSWORD);
        return CollabConfigurationHelper.getProperty((String)JETTY_SSL_KEY_PASSWORD, (String)CommonUtil.getString(object, null));
    }

    public boolean isHttpEnabled() {
        Object object = this.configurationProperties.get(JETTY_HTTP_ENABLE);
        return CommonUtil.getBoolean(object, Boolean.TRUE);
    }

    public int getHttpPort() {
        Object object = this.configurationProperties.get(JETTY_HTTP_PORT);
        return CommonUtil.getInt(object, 8080);
    }

    public String getHttpHost() {
        Object object = this.configurationProperties.get(JETTY_HTTP_HOST);
        return CommonUtil.getString(object, "0.0.0.0");
    }

    public String getRepositoriesDirectoryPath() {
        Object object = this.configurationProperties.get(REPOSITORIES_DIRECTORY_PATH);
        return CommonUtil.getString(object, ".");
    }

    public String getRepositoriesExportDirectoryPath() {
        Object object = this.configurationProperties.get(REPOSITORIES_EXPORT_DIRECTORY_PATH);
        return CommonUtil.getString(object, ".");
    }

    public String getOpenApiDirectoryPath() {
        Object object = this.configurationProperties.get(OPENAPI_DIRECTORY_PATH);
        return CommonUtil.getString(object, "");
    }

    public String getDocDirectoryPath() {
        Object object = this.configurationProperties.get(DOC_DIRECTORY_PATH);
        return CommonUtil.getString(object, "");
    }

    public String getLocalClientCallLogsDirectoryPath() {
        Object object = this.configurationProperties.get(ADMIN_SERVER_LOCAL_CLIENT_LOGS_DIRECTORY_PATH);
        return CommonUtil.getString(object, ".");
    }

    public boolean isRepositoriesExportDirectoryIsVisible() {
        Object object = this.configurationProperties.get(REPOSITORIES_EXPORT_DIRECTORY_FILESERVER_ALLOW_DIRECTORY);
        return CommonUtil.getBoolean(object, Boolean.FALSE);
    }

    public String getLDAPTrustStorePath() {
        String object = this.configurationProperties.getProperty(LDAP_TRUSTSTORE_PATH);
        return CommonUtil.getString(object, "");
    }

    public Object get(Object key) {
        return this.configurationProperties.get(key);
    }

    public Object getOrDefault(Object key, Object dflt) {
        return this.configurationProperties.getOrDefault(key, dflt);
    }

    public boolean haveToStartJetty() {
        if (Boolean.getBoolean("fr.obeo.dsl.viewpoint.collab.server.admin.jetty.realm.file")) {
            String adminServerConfigurationPath = this.getAdminServerConfigurationPath();
            File file = Paths.get(adminServerConfigurationPath, REALM_PROPERTIES_FILE_NAME).toFile();
            String emptyPropertiesError = String.format(EMPTY_PROPERTIES_FILE_ERROR, "jetty", REALM_PROPERTIES_FILE_NAME);
            String readPropertiesFileError = String.format(READ_PROPERTIES_FILE_ERROR, "jetty", REALM_PROPERTIES_FILE_NAME);
            return this.checkPropertiesFile(file, emptyPropertiesError, readPropertiesFileError);
        }
        return true;
    }

    public String getRealmPropertiesFilePath() {
        String adminServerConfigurationPath = this.getAdminServerConfigurationPath();
        return Paths.get(adminServerConfigurationPath, REALM_PROPERTIES_FILE_NAME).toString();
    }

    public boolean haveToStartAdminServer() {
        String adminServerConfigurationPath = this.getAdminServerConfigurationPath();
        File adminPropertiesFile = Paths.get(adminServerConfigurationPath, ADMIN_SERVER_PROPERTIES_FILE_NAME).toFile();
        String emptyPropertiesError = String.format(EMPTY_PROPERTIES_FILE_ERROR, "administration", ADMIN_SERVER_PROPERTIES_FILE_NAME);
        String readPropertiesFileError = String.format(READ_PROPERTIES_FILE_ERROR, "administration", ADMIN_SERVER_PROPERTIES_FILE_NAME);
        return this.checkPropertiesFile(adminPropertiesFile, emptyPropertiesError, readPropertiesFileError);
    }

    private boolean checkPropertiesFile(File propertiesFile, String emptyPropertiesError, String readPropertiesError) {
        boolean checked = propertiesFile.exists();
        if (checked) {
            Properties properties = new Properties();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream fis = new FileInputStream(propertiesFile);){
                    properties.load(fis);
                    if (properties.isEmpty()) {
                        checked = false;
                        OM.LOG.error(emptyPropertiesError);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                checked = false;
                OM.LOG.error(readPropertiesError, (Throwable)e);
            }
        }
        return checked;
    }

    public static String getDirectoryPathFromProperties(String directoryPathFromProperties, Bundle bundle) throws IOException, URISyntaxException {
        String directoryPath = directoryPathFromProperties;
        if (StringUtil.isEmpty(directoryPath)) {
            URL resourceBaseUrl = bundle.getResource(".");
            URL resolvedURL = FileLocator.resolve((URL)resourceBaseUrl);
            URI frontendResourcesURI = URIUtil.toURI((URL)resolvedURL);
            Path path = new Path(new File(frontendResourcesURI).getAbsolutePath());
            if (path.segmentCount() > 1 && "bin".equals(path.segment(path.segmentCount() - 1))) {
                path = path.removeLastSegments(1);
            }
            directoryPath = path.toOSString();
        }
        return directoryPath;
    }

    public boolean isAdminFromServletsEnabled() {
        Object object = this.configurationProperties.get(ADMIN_SERVER_JETTY_ADMIN_SERVLETS_ENABLED);
        return CommonUtil.getBoolean(object, Boolean.TRUE);
    }

    public boolean isDocAndOpenApiServletsEnabled() {
        Object object = this.configurationProperties.get(ADMIN_SERVER_JETTY_ADMIN_DOC_OPENAPI_SERVLETS_ENABLED);
        return CommonUtil.getBoolean(object, Boolean.TRUE);
    }

    public boolean isNet4JWebsocketTransportEnabled() {
        Object object = this.configurationProperties.get(ADMIN_SERVER_JETTY_NET4J_ENABLED);
        return CommonUtil.getBoolean(object, Boolean.FALSE);
    }

    public String getNet4J() {
        Object object = this.configurationProperties.get(ADMIN_SERVER_JETTY_NET4J_PATH);
        return CommonUtil.getString(object, "net4j");
    }

    public boolean removePublicConstraintFromNet4JServlet() {
        Object object = this.configurationProperties.get(ADMIN_SERVER_JETTY_NET4J_REMOVE_PUBLIC_CONSTRAINT);
        return CommonUtil.getBoolean(object, Boolean.FALSE);
    }

    public Collection<String> getKeys() {
        return this.configurationProperties.stringPropertyNames();
    }

    private static class AdminServerConfigurationHelperHolder {
        private static final AdminServerConfigurationHelper INSTANCE = new AdminServerConfigurationHelper();

        private AdminServerConfigurationHelperHolder() {
        }
    }
}

