/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.transaction.CDOTransaction;

public final class CommonUtil {
    private CommonUtil() {
    }

    public static String decodeURIComponent(String s) {
        if (s == null) {
            return null;
        }
        String result = null;
        try {
            result = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    public static <T> List<T> removeNullObjectsFromList(List<T> list) {
        return list.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void createProperiesFileFromMap(String path, Map<String, String> propertiesMap) throws IOException {
        boolean write;
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        File propertiesFile = new File(path);
        if (!propertiesFile.getParentFile().exists()) {
            propertiesFile.getParentFile().mkdirs();
        }
        if (write = !propertiesFile.exists() ? propertiesFile.createNewFile() : Boolean.getBoolean("fr.obeo.dsl.viewpoint.collab.server.admin.repositories.dynamic.properties.files.reinit.on.start")) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileOutputStream outputStream = new FileOutputStream(propertiesFile);){
                properties.store(outputStream, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static Realm getRealmFromTransaction(CDOTransaction transaction) {
        return (Realm)transaction.getResource("users.userprofile").getContents().get(0);
    }

    public static boolean getBoolean(Object object, boolean dflt) {
        boolean result = dflt;
        if (object instanceof Boolean) {
            result = (Boolean)object;
        } else if (object instanceof String) {
            result = Boolean.parseBoolean((String)object);
        }
        return result;
    }

    public static int getInt(Object object, int dflt) {
        int result = dflt;
        if (object instanceof Integer) {
            result = (Integer)object;
        } else if (object instanceof String) {
            result = Integer.parseInt((String)object);
        }
        return result;
    }

    public static String getString(Object object, String dflt) {
        String result = dflt;
        if (object instanceof String) {
            result = (String)object;
        }
        return result;
    }
}

