/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.GetRepositoriesResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.NewRepository;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.Repository;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.LoggerFactory;

public class RepositoriesResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/repositories";
    private static final String ERROR_MESSAGE = "The repository %1$s has not been created.";
    private static final String CREATE_REPOSITORY_LOG_MESSAGE = "Create repository '{}' - called by '{}'";
    private static final String LIST_REPOSITORIES_LOG_MESSAGE = "List Repositories - called by '{}'";
    private static final long serialVersionUID = 1276459772947917634L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo").info(LIST_REPOSITORIES_LOG_MESSAGE, (Object)req.getRemoteUser());
        List<Repository> allRepositories = CDORepositoryUtil.getAllRepositories();
        GetRepositoriesResponse response = ResponseFactory.createGetRepositoriesResponse(allRepositories);
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IStatus status;
        AbstractResponse response = null;
        NewRepository newRepository = JsonBodyReader.read((ServletRequest)req, NewRepository.class);
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo").info(CREATE_REPOSITORY_LOG_MESSAGE, (Object)newRepository.getRepositoryName(), (Object)req.getRemoteUser());
        String diagnostic = AdminServletValidator.validate(newRepository);
        response = "NO_ISSUE_DIAGNOSTIC".equals(diagnostic) ? ((status = CDORepositoryUtil.createRepository(newRepository)).isOK() ? CDORepositoryUtil.getRepository(newRepository.getRepositoryName()).map(ResponseFactory::createNewRepositoryResponse).map(AbstractResponse.class::cast).orElseGet(() -> this.getCreateNewRepositoryErrorResponse(newRepository, null)) : this.getCreateNewRepositoryErrorResponse(newRepository, status)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, newRepository.getRepositoryName()), diagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo");
    }

    private ErrorResponse getCreateNewRepositoryErrorResponse(NewRepository newRepository, IStatus status) {
        StringBuilder messageBuilder = new StringBuilder("An error occurred during the repository configuration: ");
        if (status != null) {
            messageBuilder.append(status.getMessage());
            if (status.getException() != null) {
                messageBuilder.append("\nException: ").append(status.getException().getMessage());
            }
        }
        return ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, newRepository.getRepositoryName()), messageBuilder.toString());
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }
}

