/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.Repository;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.LoggerFactory;

public class RepositoryResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/repositories/*";
    private static final String DELETE_DATABASE_QUERY_PARAMETER = "deleteDatabase";
    private static final int REPOSITORYNAME_PATH_INFO_POSITION = 0;
    private static final String DELETE_REPOSITORY_LOG_MESSAGE = "Delete repository '{}' - called by '{}'";
    private static final long serialVersionUID = -2011141950251386341L;
    private static final String ERROR_MESSAGE = "The repository %1$s has not been deleted.";

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IStatus status;
        Optional<Repository> repository;
        String validatedRepository;
        AbstractResponse response = null;
        String repositoryName = new PathParamReader(req).getPathSegment(0);
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo").info(DELETE_REPOSITORY_LOG_MESSAGE, (Object)repositoryName, (Object)req.getRemoteUser());
        boolean deleteDatabase = Optional.ofNullable(req.getParameter(DELETE_DATABASE_QUERY_PARAMETER)).map(Boolean::parseBoolean).orElse(Boolean.TRUE);
        String validatedRepositoryName = AdminServletValidator.validateRepositoryName(repositoryName);
        response = "NO_ISSUE_DIAGNOSTIC".equals(validatedRepositoryName) ? ("NO_ISSUE_DIAGNOSTIC".equals(validatedRepository = AdminServletValidator.validateRepository(repositoryName, AdminServletValidator.RequiredRepositoryStatus.NONE)) ? ((repository = CDORepositoryUtil.getRepository(repositoryName)).isPresent() && Repository.RepositoryType.STATIC.equals((Object)repository.get().getType()) ? ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), "Static repository not managed on this service.") : ((status = CDORepositoryUtil.deleteRepository(repositoryName)).isOK() ? ResponseFactory.createDeletedRepositoryResponse(repositoryName, deleteDatabase) : this.createInternalErrorResponse(repositoryName, status))) : ResponseFactory.createNotFoundErrorResponse(String.format(ERROR_MESSAGE, repositoryName), validatedRepository)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), validatedRepositoryName);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo");
    }

    private AbstractResponse createInternalErrorResponse(String repositoryName, IStatus status) {
        StringBuilder messageBuilder = new StringBuilder("Something happens during the repository deletion: ");
        messageBuilder.append(status.getMessage());
        if (status.getException() != null) {
            messageBuilder.append("\nException: ").append(status.getException().getMessage());
        }
        ErrorResponse response = ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, repositoryName), messageBuilder.toString());
        return response;
    }
}

