/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.net4j.util.io.IOUtil;

public class ExportStaticResourceServlet
extends HttpServlet {
    private static final String ERROR_MESSAGE = "The file cannot be retrieved.";
    private static final long serialVersionUID = 310519751235385710L;
    private final Path root;

    public ExportStaticResourceServlet(Path root) {
        this.root = root;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block13: {
            String pathInfo = req.getPathInfo();
            if (!StringUtil.isEmpty(pathInfo)) {
                File file;
                if (pathInfo.startsWith("/")) {
                    pathInfo = pathInfo.substring(1);
                }
                if ((file = this.root.resolve(pathInfo).toFile()).exists()) {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (FileInputStream os = new FileInputStream(file);){
                        IOUtil.copy((InputStream)os, (OutputStream)resp.getOutputStream());
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                ErrorResponse errorResponse = ResponseFactory.createNotFoundErrorResponse(ERROR_MESSAGE, "The file has not been found or may not be created yet: " + pathInfo);
                resp.setStatus(errorResponse.getStatus());
                JsonBodyWriter.write(resp, errorResponse.getClass(), errorResponse, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.others");
            } else {
                ErrorResponse errorResponse = ResponseFactory.createBadRequestErrorResponse(ERROR_MESSAGE, "The path to the file is invalid.");
                resp.setStatus(errorResponse.getStatus());
                JsonBodyWriter.write(resp, errorResponse.getClass(), errorResponse, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.others");
            }
        }
    }
}

