/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.operation;

import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityMetadataExport;
import fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata.CommitMetadataExporter;
import fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata.SquashingCdoCommitMetadataExporter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IAdminServlet;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.PathParamReader;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDOServerCommitMetadataExporter;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.slf4j.LoggerFactory;

public class HistoryRepositoryResource
extends HttpServlet
implements IAdminServlet {
    public static final String ALIAS = "/api/v1.0/repositories/history/*";
    private static final String ERROR_MESSAGE = "The history of repository %1$s has not been exported.";
    private static final String EXPORT_COMMIT_HISTORY_LOG_MESSAGE = "Export the commit history of repository '{}' from '{}' to '{}' (squashCommitHistory:'{}' - includeChanges:'{}') - called by '{}'";
    private static final int REPOSITORYNAME_PATH_INFO_POSITION = 0;
    private static final String FROM_QUERY_PARAMETER = "from";
    private static final String TO_QUERY_PARAMETER = "to";
    private static final String INCLUDE_CHANGES_QUERY_PARAMETER = "includeChanges";
    private static final String SQUASH_COMMIT_HISTORY_QUERY_PARAMETER = "squashCommitHistory";
    private static final long serialVersionUID = -1125529789170034583L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String repositoryStatusDiagnostic;
        String repositoryExistsDiagnostic;
        AbstractResponse response = null;
        String repositoryName = new PathParamReader(req).getPathSegment(0);
        String from = Optional.ofNullable(req.getParameter(FROM_QUERY_PARAMETER)).orElse(null);
        String to = Optional.ofNullable(req.getParameter(TO_QUERY_PARAMETER)).orElse(null);
        boolean squashCommitHistory = Optional.ofNullable(req.getParameter(SQUASH_COMMIT_HISTORY_QUERY_PARAMETER)).map(Boolean::parseBoolean).orElse(Boolean.TRUE);
        boolean includeChanges = Optional.ofNullable(req.getParameter(INCLUDE_CHANGES_QUERY_PARAMETER)).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo").info(EXPORT_COMMIT_HISTORY_LOG_MESSAGE, new Object[]{repositoryName, from, to, squashCommitHistory, includeChanges, req.getRemoteUser()});
        String repositoryNameDiagnostic = AdminServletValidator.validateRepositoryName(repositoryName);
        response = "NO_ISSUE_DIAGNOSTIC".equals(repositoryNameDiagnostic) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryExistsDiagnostic = AdminServletValidator.validateRepositoryExists(repositoryName)) ? ("NO_ISSUE_DIAGNOSTIC".equals(repositoryStatusDiagnostic = AdminServletValidator.validateRepositoryStatus(repositoryName, AdminServletValidator.RequiredRepositoryStatus.STARTED)) ? this.doHistoryRepository(repositoryName, from, to, squashCommitHistory, includeChanges) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryStatusDiagnostic)) : ResponseFactory.createNotFoundErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryExistsDiagnostic)) : ResponseFactory.createBadRequestErrorResponse(String.format(ERROR_MESSAGE, repositoryName), repositoryNameDiagnostic);
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write(resp, response.getClass(), response, req.getRemoteUser(), "fr.obeo.dsl.viewpoint.collab.server.operation.rest.admin.repo");
    }

    private AbstractResponse doHistoryRepository(String repositoryName, String from, String to, boolean squashCommitHistory, boolean includeChanges) {
        AbstractResponse result = this.buildErrorMessage(repositoryName, null);
        Optional<InternalRepository> repo = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        if (repo.isPresent()) {
            ActivityMetadataExport commitHistory;
            IStoreAccessor reader = repo.get().getStore().getReader(null);
            StoreThreadLocal.setAccessor((IStoreAccessor)reader);
            try {
                try {
                    commitHistory = this.importCommitHistory(repo.get(), from, to, squashCommitHistory, includeChanges);
                }
                catch (IllegalArgumentException e) {
                    AbstractResponse abstractResponse = this.buildErrorMessage(repositoryName, Status.error((String)e.getMessage()));
                    StoreThreadLocal.release();
                    return abstractResponse;
                }
            }
            finally {
                StoreThreadLocal.release();
            }
            result = CDORepositoryUtil.getRepository(repositoryName).map(r -> ResponseFactory.createRepositoryHistoryResponse(r, commitHistory)).map(AbstractResponse.class::cast).orElseGet(() -> this.buildErrorMessage(repositoryName, null));
        }
        return result;
    }

    private AbstractResponse buildErrorMessage(String repositoryName, IStatus status) {
        StringBuilder messageBuilder = new StringBuilder("An error occurred while exporting the repository commit history: ");
        if (status != null) {
            messageBuilder.append(status.getMessage());
            if (status.getException() != null) {
                messageBuilder.append("\nException: ").append(status.getException().getMessage());
            }
        }
        return ResponseFactory.createInternalServerErrorResponse(String.format(ERROR_MESSAGE, repositoryName), messageBuilder.toString());
    }

    private ActivityMetadataExport importCommitHistory(InternalRepository repository, String from, String to, boolean squashCommitHistory, boolean includeChanges) {
        CDOServerCommitMetadataExporter metadataExporter = new CDOServerCommitMetadataExporter();
        if (squashCommitHistory) {
            metadataExporter = new SquashingCdoCommitMetadataExporter((CommitMetadataExporter)metadataExporter);
        }
        Instant fromInstant = null;
        if (from == null) {
            fromInstant = new Date(repository.getCreationTime()).toInstant();
        } else {
            try {
                fromInstant = CommitMetadataExporter.parseDateTime((String)from);
            }
            catch (IllegalStateException | DateTimeParseException parseException) {
                throw new IllegalArgumentException("Could not parse " + from + " as a timestamp. Please use one of the timestamp accepted formats (\"yyyy-MM-dd'T'HH:mm:ss.SSSZ\", local time in ISO format \"yyyy-MM-dd'T'HH:mm:ss\" or time in ms since epoch).", parseException);
            }
        }
        Instant toInstant = null;
        if (to == null) {
            toInstant = CommitMetadataExporter.getHeadInstant((CDOCommitInfoManager)repository.getCommitInfoManager(), (CDOBranch)repository.getBranchManager().getMainBranch());
        } else {
            try {
                toInstant = CommitMetadataExporter.parseDateTime((String)to);
            }
            catch (IllegalStateException | DateTimeParseException parseException) {
                throw new IllegalArgumentException("Could not parse " + to + " as a timestamp. Please use one of the timestamp accepted formats (\"yyyy-MM-dd'T'HH:mm:ss.SSSZ\", local time in ISO format \"yyyy-MM-dd'T'HH:mm:ss\" or time in ms since epoch).", parseException);
            }
        }
        if (from != null && to != null && toInstant != Instant.EPOCH && !fromInstant.equals(toInstant) && fromInstant.isAfter(toInstant)) {
            throw new IllegalArgumentException("'from' timestamp (" + fromInstant.toString() + ") should be earlier than the 'to' timestamp (" + fromInstant.toString() + ").");
        }
        ActivityMetadataExport metadataExport = this.export(repository, (CommitMetadataExporter)metadataExporter, fromInstant, toInstant, includeChanges);
        return metadataExport;
    }

    private ActivityMetadataExport export(InternalRepository repository, CommitMetadataExporter metadataExporter, Instant from, Instant to, boolean exportChanges) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        InternalCDOCommitInfoManager commitInfoManager = repository.getCommitInfoManager();
        InternalCDOBranch mainBranch = repository.getBranchManager().getMainBranch();
        return metadataExporter.export((CDOCommitInfoManager)commitInfoManager, (CDOBranch)mainBranch, from, to, exportChanges, false);
    }
}

