/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;

public class LocalClientCall {
    protected static final String APP_ID = "application";
    protected static final String WS_PATH_ID = "data";
    protected static final String ARG_PREFIX = "-";
    private static final String WINDOWS_EXE_EXTENSION = ".exe";
    private static final String WINDOWS_CONSOLE_EXTENSION = "c.exe";
    private static final String EXTERNAL_FILE_SUFFIX = "File";
    private static final String EXE_PROP = "exe";
    private static final String NO_POPUP_ERROR_FLAG = "--launcher.suppressErrors";
    private static final String CONSOLE_FLAG = "-console";
    private static final String CONSOLE_LOG_FLAG = "-consoleLog";
    private static final String HEADLESS_FLAG = "-noSplash";
    private static final String VM_ARG_PREFIX = "vm.args.";
    private static final String ECLIPSE_VM_ARG = "-vmargs";
    private static final String DEFAULT_EXE_PATH = "../../eclipse";
    protected final Map<String, String> defaulArgs;
    private final ILog log = Platform.getLog(this.getClass());
    private final String exePath;
    private final String wsPath;
    private final Collection<String> defaultVmArgs;
    private Process single;

    public LocalClientCall(String prefix) {
        this(prefix, null);
    }

    public LocalClientCall(String prefix, Properties defaultProps) {
        Properties configuration = LocalClientCall.extractInlineProperties(prefix, defaultProps);
        this.loadExternalProperties(prefix, configuration);
        Object exeValue = configuration.getProperty(EXE_PROP, DEFAULT_EXE_PATH);
        if ("win32".equals(Platform.getOS()) && !((String)exeValue).toLowerCase().endsWith(WINDOWS_EXE_EXTENSION)) {
            exeValue = (String)exeValue + WINDOWS_CONSOLE_EXTENSION;
        }
        this.exePath = Paths.get((String)exeValue, new String[0]).toString();
        this.wsPath = configuration.getProperty(WS_PATH_ID);
        this.defaulArgs = LocalClientCall.buildDefaultAppArgs(configuration);
        this.defaultVmArgs = this.buildDefaultVmArgs(configuration);
    }

    protected String getWsPath() {
        return this.wsPath;
    }

    private void loadExternalProperties(String prefix, Properties props) {
        Object configFile = AdminServerConfigurationHelper.getInstance().get(prefix + EXTERNAL_FILE_SUFFIX);
        if (configFile instanceof String) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream cfgFile = new FileInputStream(Paths.get((String)configFile, new String[0]).toFile());){
                    props.load(cfgFile);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log.error("Fail to load client configuration of " + prefix, (Throwable)e);
            }
        }
    }

    private static Map<String, String> buildDefaultAppArgs(Properties config) {
        return config.stringPropertyNames().stream().filter(LocalClientCall::isArg).collect(Collectors.toMap(it -> ARG_PREFIX + it, config::getProperty));
    }

    private static Properties extractInlineProperties(String prefix, Properties defaultProps) {
        String inlinePrefix = prefix + ".";
        AdminServerConfigurationHelper globalConfig = AdminServerConfigurationHelper.getInstance();
        Properties result = new Properties(defaultProps);
        globalConfig.getKeys().stream().filter(it -> it.startsWith(inlinePrefix)).forEach(it -> {
            Object object = result.put(it.substring(inlinePrefix.length()), globalConfig.get(it));
        });
        return result;
    }

    private List<String> buildDefaultVmArgs(Properties config) {
        return config.stringPropertyNames().stream().filter(LocalClientCall::isVmArg).map(it -> new VmArg((String)it, config)).sorted((a, b) -> a.index - b.index).map(it -> it.value).collect(Collectors.toList());
    }

    protected Process runSingleInstance(Callable<Process> task) throws ConcurrentModificationException, IOException {
        LocalClientCall localClientCall = this;
        synchronized (localClientCall) {
            if (this.single != null) {
                throw new ConcurrentModificationException();
            }
            try {
                Process result;
                this.single = result = task.call();
                result.onExit().thenAccept(it -> {
                    LocalClientCall localClientCall = this;
                    synchronized (localClientCall) {
                        this.single = null;
                    }
                });
                return result;
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e.getMessage(), e);
            }
        }
    }

    protected Process execute(File redirectedLog, String ... args) throws IOException {
        return this.execute(redirectedLog, Arrays.asList(args));
    }

    protected Process execute(File redirectedLog, List<String> args) throws IOException {
        return this.execute(redirectedLog, args, Collections.emptyList());
    }

    protected Process execute(File redirectedLog, List<String> args, List<String> vmArgs) throws IOException {
        int fullSize = 4 + args.size() + this.defaulArgs.size() * 2 + this.defaultVmArgs.size() + vmArgs.size();
        ArrayList<String> command = new ArrayList<String>(fullSize);
        command.add(this.exePath);
        command.add(NO_POPUP_ERROR_FLAG);
        command.add(HEADLESS_FLAG);
        command.add(CONSOLE_FLAG);
        command.add(CONSOLE_LOG_FLAG);
        command.addAll(args);
        this.defaulArgs.entrySet().stream().filter(it -> !args.contains(it.getKey())).forEach(it -> {
            command.add((String)it.getKey());
            if (it.getValue() != null) {
                command.add((String)it.getValue());
            }
        });
        if (!this.defaultVmArgs.isEmpty() || !vmArgs.isEmpty()) {
            command.add(ECLIPSE_VM_ARG);
            command.addAll(this.defaultVmArgs);
            command.addAll(vmArgs);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (redirectedLog != null) {
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput(redirectedLog);
        }
        return processBuilder.start();
    }

    private static boolean isArg(String key) {
        return !EXE_PROP.equals(key) && !LocalClientCall.isVmArg(key);
    }

    private static boolean isVmArg(String key) {
        return key.startsWith(VM_ARG_PREFIX);
    }

    public class Invocation {
        final long pid;
        private Path log;

        public Invocation(long pid, File redirectedLog) {
            this.pid = pid;
            this.log = redirectedLog.toPath();
        }

        public long getPid() {
            return this.pid;
        }

        public Path getLog() {
            return this.log;
        }
    }

    private static class VmArg {
        private final String value;
        private final int index;

        VmArg(String key, Properties configuration) {
            int parsed;
            this.value = configuration.getProperty(key);
            try {
                String indexSuffix = key.substring(LocalClientCall.VM_ARG_PREFIX.length());
                parsed = Integer.parseInt(indexSuffix);
            }
            catch (NumberFormatException nfe) {
                parsed = Integer.MAX_VALUE;
            }
            this.index = parsed;
        }
    }
}

