/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.IRepositoryManagerDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.util.om.log.OMLogger;

public class RepositoryManagerDescriptor
implements IRepositoryManagerDescriptor {
    protected String id;
    protected String keyValue;
    private final String extensionClassName;
    private IConfigurationElement element;

    public RepositoryManagerDescriptor(IConfigurationElement configuration) {
        this.id = configuration.getDeclaringExtension().getUniqueIdentifier();
        this.keyValue = configuration.getAttribute("key");
        this.extensionClassName = configuration.getAttribute("class");
        this.element = configuration;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IRepositoryManager getRepositoryManager() {
        IRepositoryManager repositoryManager = null;
        if (Platform.isRunning()) {
            try {
                repositoryManager = (IRepositoryManager)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                OM.LOG.log(OMLogger.Level.ERROR, String.format("Error while loading the extension %1$s", this.element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e);
            }
        }
        return repositoryManager;
    }

    @Override
    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    @Override
    public String getKeyValue() {
        return this.keyValue;
    }
}

