/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.project;

import fr.obeo.dsl.viewpoint.collab.common.internal.commit.CommitCommentUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.NewSharedModelingProject;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.RepositoryManagerService;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.common.util.CDODuplicateResourceException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointFactory;

public final class ProjectUtil {
    private ProjectUtil() {
    }

    public static IStatus createNewEmptyRemoteProject(NewSharedModelingProject newSharedModelingProject, CDOTransaction cdoTransaction) {
        IStatus status = Status.OK_STATUS;
        String repositoryName = newSharedModelingProject.getRepositoryName();
        String projectName = newSharedModelingProject.getProjectName();
        DAnalysis dAnalysis = ViewpointFactory.eINSTANCE.createDAnalysis();
        CDOResourceFolder remoteProjectFolder = cdoTransaction.getOrCreateResourceFolder(projectName);
        try {
            CDOResource remoteAirdResource = remoteProjectFolder.addResource("representations.aird");
            remoteAirdResource.getContents().add((Object)dAnalysis);
            cdoTransaction.setCommitComment(CommitCommentUtil.fitCommitDescriptionLength((String)("[REST Admin] Create Project " + projectName)));
            cdoTransaction.commit();
        }
        catch (CDODuplicateResourceException | CommitException e) {
            String message = String.format("The project %1$s has not been correctly created.", projectName);
            OM.LOG.error(message, e);
            cdoTransaction.rollback();
            status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", message, e);
        }
        if (status.isOK()) {
            Optional<String> optionalAuthType = CDORepositoryUtil.getAuthenticationType(repositoryName);
            String authType = optionalAuthType.orElse("");
            IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(authType);
            IStatus postCreationStatus = repositoryManager.postSharedModelingProjectCreation(newSharedModelingProject);
            if (status.getSeverity() == 4) {
                OM.LOG.error("The post shared modeling project went wrong", status.getException());
                status = postCreationStatus;
            }
        }
        return status;
    }
}

