/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.security;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap.LDAPAuthenticator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.common.security.NoPermissionException;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.security.IAuthenticator;

public final class UserUtil {
    private UserUtil() {
    }

    public static SimpleUser mapToSimpleUser(User cdoUser) {
        SimpleUser user = new SimpleUser();
        if (cdoUser != null) {
            user.setId(cdoUser.getId());
            user.setFirstName(cdoUser.getFirstName());
            user.setLastName(cdoUser.getLastName());
            user.setLabel(cdoUser.getLastName());
            user.setEmail(cdoUser.getEmail());
            if (Access.WRITE == cdoUser.getDefaultAccessOverride()) {
                user.setAdmin(true);
            }
            List<String> projectNames = cdoUser.getRoles().stream().map(Role::getId).collect(Collectors.toList());
            user.setPermissions(projectNames);
        }
        return user;
    }

    public static IStatus createUser(NewUser newUser, CDOTransaction transaction, String repositoryName) {
        IStatus status;
        block6: {
            status = Status.OK_STATUS;
            Realm realm = CommonUtil.getRealmFromTransaction(transaction);
            boolean isPasswordToStore = true;
            isPasswordToStore = UserUtil.shouldStorePassword(repositoryName);
            User user = SecurityFactory.eINSTANCE.createUser();
            user.setId(newUser.getId());
            if (isPasswordToStore) {
                UserPassword userPassword = SecurityFactory.eINSTANCE.createUserPassword();
                userPassword.setEncrypted(newUser.getPassword());
                user.setPassword(userPassword);
            }
            if (newUser.isAdministrator()) {
                user.setDefaultAccessOverride(Access.WRITE);
            } else {
                user.setDefaultAccessOverride(Access.READ);
            }
            try {
                realm.getItems().add((Object)user);
                if (newUser.getPermissions() != null) {
                    UserUtil.setPermissions(transaction, user, newUser.getPermissions());
                }
            }
            catch (NoPermissionException e) {
                String msg = e.getLocalizedMessage();
                status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", e.getLocalizedMessage(), (Throwable)e);
                if (msg == null || !msg.startsWith("No permission to access Realm@")) break block6;
                msg = "No permission to add a new user.";
                status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", msg, (Throwable)new NoPermissionException(e.getProtectableObject(), msg));
            }
        }
        return status;
    }

    private static boolean shouldStorePassword(String repositoryName) {
        return CDORepositoryUtil.getAuthenticator(repositoryName).map(UserUtil::shouldStorePassword).orElse(Boolean.FALSE);
    }

    private static boolean shouldStorePassword(IAuthenticator authenticator) {
        IAuthenticator delegate;
        boolean isPasswordToStore;
        boolean bl = isPasswordToStore = !(authenticator instanceof LDAPAuthenticator);
        if (isPasswordToStore && authenticator instanceof IAuthenticatorDelegate && (delegate = ((IAuthenticatorDelegate)authenticator).getAuthenticator()) != authenticator) {
            isPasswordToStore = UserUtil.shouldStorePassword(delegate);
        }
        return isPasswordToStore;
    }

    private static void setPermissions(CDOTransaction transaction, User user, List<String> roleNames) {
        Realm realm = CommonUtil.getRealmFromTransaction(transaction);
        for (String roleName : roleNames) {
            Role role = realm.getRole(roleName);
            if (role == null) continue;
            user.getRoles().add((Object)role);
        }
    }

    public static Optional<User> deleteUser(CDOTransaction transaction, String userName) {
        Realm realm = CommonUtil.getRealmFromTransaction(transaction);
        Optional<User> user = Optional.ofNullable(realm.getUser(userName));
        user.ifPresent(EcoreUtil::delete);
        return user;
    }

    public static String validateUserPassword(String password, String emptyPasswordDiagnostic) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (StringUtil.isEmpty(password)) {
            diagnostic = emptyPasswordDiagnostic;
        } else if (!StringUtil.isEmpty(password) && (password.startsWith(String.valueOf(' ')) || password.endsWith(String.valueOf(' ')))) {
            diagnostic = "The password cannot begin or end with a space.";
        }
        return diagnostic;
    }
}

