/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.security;

import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.internal.security.RealmOperationAuthorizer;
import org.eclipse.emf.cdo.server.internal.security.SecurityManager;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.AnnotationHandler;
import org.eclipse.emf.cdo.server.spi.security.HomeFolderHandler;
import org.eclipse.emf.cdo.server.spi.security.SecurityManagerFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.IFactory;

public final class SecurityManagerUtil {
    private SecurityManagerUtil() {
    }

    public static ISecurityManager getSecurityManager(IRepository repository) {
        return SecurityManager.get(repository);
    }

    public static ISecurityManager createSecurityManager(String realmPath) {
        return SecurityManagerUtil.createSecurityManager(realmPath, (IManagedContainer)IPluginContainer.INSTANCE);
    }

    public static ISecurityManager createSecurityManager(String realmPath, IManagedContainer container) {
        return new SecurityManager(realmPath, container);
    }

    public static void prepareContainer(IManagedContainer container) {
        container.registerFactory((IFactory)new SecurityManagerFactory.Default());
        container.registerFactory((IFactory)new SecurityManagerFactory.Annotation());
        container.registerFactory((IFactory)new AnnotationHandler.Factory());
        container.registerFactory((IFactory)new HomeFolderHandler.Factory());
        container.registerFactory((IFactory)new RealmOperationAuthorizer.RequireUser.Factory());
        container.registerFactory((IFactory)new RealmOperationAuthorizer.RequireGroup.Factory());
        container.registerFactory((IFactory)new RealmOperationAuthorizer.RequireRole.Factory());
    }
}

