/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.security.SecurityUtil;
import org.eclipse.net4j.util.security.UserManager;

public class FileUserManager
extends UserManager {
    private static final boolean FALL_BACK_TO_CONFIG_FOLDER = OMPlatform.INSTANCE.isProperty("net4j.security.FileUserManager.fallBackToConfigFolder");
    private static final boolean FAIL_IF_FILE_DOES_NOT_EXIST = OMPlatform.INSTANCE.isProperty("net4j.security.FileUserManager.failIfFileDoesNotExist");
    private static final String CONFIG_FOLDER_PREFIX = "@config/";
    protected String fileName;
    private File file;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.checkInactive();
        this.fileName = fileName;
    }

    public final File getFile() {
        return this.file;
    }

    protected File resolveFile(String fileName) throws Exception {
        if (StringUtil.isEmpty(fileName)) {
            return null;
        }
        File file = fileName.replace('\\', '/').startsWith(CONFIG_FOLDER_PREFIX) ? OMPlatform.INSTANCE.getConfigFile(fileName.substring(CONFIG_FOLDER_PREFIX.length())) : new File(fileName);
        if (FALL_BACK_TO_CONFIG_FOLDER && !file.isFile()) {
            file = OMPlatform.INSTANCE.getConfigFile(fileName);
        }
        if (file == null || !file.isFile()) {
            throw new FileNotFoundException("User manager file not found: " + fileName);
        }
        return file;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.file = this.resolveFile(this.fileName);
        if (this.file != null) {
            this.file = this.file.getCanonicalFile();
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        this.file = null;
    }

    @Override
    protected void load(Map<String, char[]> users) throws IORuntimeException {
        if (this.file != null && (FAIL_IF_FILE_DOES_NOT_EXIST || this.file.isFile())) {
            FileInputStream stream = IOUtil.openInputStream(this.file);
            try {
                try {
                    this.load(users, stream);
                }
                catch (IOException ex) {
                    throw new IORuntimeException(ex);
                }
            }
            finally {
                IOUtil.closeSilent(stream);
            }
        }
    }

    protected void load(Map<String, char[]> users, InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String userID = (String)entry.getKey();
            char[] password = SecurityUtil.toCharArray((String)entry.getValue());
            users.put(userID, password);
        }
    }

    @Override
    protected void save(Map<String, char[]> users) throws IORuntimeException {
        if (this.file != null) {
            this.file.getParentFile().mkdirs();
            FileOutputStream stream = IOUtil.openOutputStream(this.file);
            try {
                try {
                    this.save(users, stream);
                }
                catch (IOException ex) {
                    throw new IORuntimeException(ex);
                }
            }
            finally {
                IOUtil.closeSilent(stream);
            }
        }
    }

    protected void save(Map<String, char[]> users, FileOutputStream stream) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, char[]> entry : users.entrySet()) {
            properties.put(entry.getKey(), SecurityUtil.toString(entry.getValue()));
        }
        String comment = MessageFormat.format("User database {0,date} {0,time,HH:mm:ss:SSS}", System.currentTimeMillis());
        properties.store(stream, comment);
    }
}

