/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager.CollabFileUserManagerConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.SpecialUserAwareAuthenticator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.FileUserManager;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.UserManager;
import org.eclipse.net4j.util.security.UserManagerAuthenticator;
import org.slf4j.LoggerFactory;

public class CollabFileUserManager
extends FileUserManager
implements IAuthenticatorDelegate,
SpecialUserAwareAuthenticator {
    private static final String USER_FILE_AUTHENTICATING_LOG_MESSAGE = "User File - Authentication of '{}'.";
    private static final String USER_FILE_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE = "User File - Authentication successful: {}'.";
    private static final String USER_FILE_AUTHENTICATION_FAILED_LOG_MESSAGE = "User File - Authentication failed: '{}'.";
    protected IAuthenticator authenticator;
    private BiFunction<String, char[], Boolean> authenticateSpecialUserFunction;

    public CollabFileUserManager(CollabFileUserManagerConfig config) {
        this.users = new LinkedHashMap();
        this.setFileName(config.getUsersFilePath());
        this.initAuthenticator(config);
    }

    protected void initAuthenticator(CollabFileUserManagerConfig config) {
        IAuthenticatorConfig authenticatorConfig = config.getAuthenticatorDelegateConfig();
        this.authenticator = authenticatorConfig != null ? authenticatorConfig.instanciateAuthenticator() : new CollabFileUserManagerAuthenticator((UserManager)this);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.authenticator instanceof Lifecycle) {
            LifecycleUtil.activate((Object)this.authenticator);
        }
    }

    public void authenticate(String userID, char[] password) {
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").info(USER_FILE_AUTHENTICATING_LOG_MESSAGE, (Object)userID);
        if (!(this.users.containsKey(userID) || this.authenticateSpecialUserFunction != null && this.authenticateSpecialUserFunction.apply(userID, password).booleanValue())) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(USER_FILE_AUTHENTICATION_FAILED_LOG_MESSAGE, (Object)userID);
            throw new SecurityException("No such user: " + userID);
        }
        this.authenticator.authenticate(userID, password);
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").trace(USER_FILE_AUTHENTICATION_SUCCESSFUL_LOG_MESSAGE, (Object)userID);
    }

    @Override
    public IAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    protected void load(Map<String, char[]> users, InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String userID = (String)entry.getKey();
            String loadedValue = (String)entry.getValue();
            char[] password = loadedValue.trim().toCharArray();
            users.put(userID, password);
        }
    }

    protected void save(Map<String, char[]> users, FileOutputStream stream) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, char[]> entry : users.entrySet()) {
            properties.put(entry.getKey(), new String(entry.getValue()));
        }
        String comment = MessageFormat.format("User database {0,date} {0,time,HH:mm:ss:SSS}", System.currentTimeMillis());
        properties.store(stream, comment);
    }

    public List<String> getUserIds() {
        return Collections.unmodifiableList(this.users.keySet().stream().collect(Collectors.toList()));
    }

    @Override
    public void setSpecialUserAuthenticator(BiFunction<String, char[], Boolean> isSpecialUserAuthenticator) {
        this.authenticateSpecialUserFunction = isSpecialUserAuthenticator;
        IAuthenticator iAuthenticator = this.authenticator;
        if (iAuthenticator instanceof SpecialUserAwareAuthenticator) {
            SpecialUserAwareAuthenticator suaa = (SpecialUserAwareAuthenticator)iAuthenticator;
            suaa.setSpecialUserAuthenticator(isSpecialUserAuthenticator);
        }
    }

    private class CollabFileUserManagerAuthenticator
    extends UserManagerAuthenticator {
        CollabFileUserManagerAuthenticator(UserManager userManager) {
            super((IUserManager)userManager);
        }

        public void authenticate(String userID, char[] password) throws SecurityException {
            boolean isWebAdmin = false;
            if (CollabFileUserManager.this.authenticateSpecialUserFunction != null && (isWebAdmin = CollabFileUserManager.this.authenticateSpecialUserFunction.apply(userID, password).booleanValue())) {
                return;
            }
            super.authenticate(userID, password);
        }
    }
}

