/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.SpecialUserAwareAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap.LDAPAuthenticatorConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.function.BiFunction;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.slf4j.LoggerFactory;

public class LDAPAuthenticator
implements IAuthenticator,
IAuthenticatorDelegate,
SpecialUserAwareAuthenticator {
    public static final String EMPTY_PASSWORD_MESSAGE = "LDAP authentication does not accept emtpy passwords.";
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String AUTHENTICATION_MODE = "simple";
    private static final String AUTHENTICATION_ERROR = "Error while authenticating against LDAP";
    private static final String ERROR_MESSAGE = "Error while connecting to the LDAP";
    private static final String LDAP_SEARCH_USER_ERROR = "Error while looking up in LDAP. Search query returned no users.";
    private static final String INCOMPLETE_LDAP_CONFIGURATION = "The LDAP configuration in the server is incomplete";
    private static final String JNDI_LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String JAVA_NAMING_LDAP_VERSION = "java.naming.ldap.version";
    private static final String COM_SUN_JNDI_DNS_TIMEOUT_RETRIES = "com.sun.jndi.dns.timeout.retries";
    private static final String COM_SUN_JNDI_DNS_TIMEOUT_INITIAL = "com.sun.jndi.dns.timeout.initial";
    private static final String COM_SUN_JNDI_LDAP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String LDAP_AUTHENTICATING = "LDAP - Authentication of '{}'.";
    private static final String LDAP_AUTHENTICATION_SUCCESSFUL = "LDAP - Authentication successful: '{}'.";
    private static final String LDAP_AUTHENTICATION_FAILED = "LDAP - Authentication failed for '{}' with error : '{}'";
    private LDAPAuthenticatorConfig config;
    private BiFunction<String, char[], Boolean> authenticateSpecialUserFunction;

    public LDAPAuthenticator(LDAPAuthenticatorConfig config) {
        this.config = config;
        this.setTrustStore(config);
    }

    public void authenticate(String userID, char[] password) throws SecurityException {
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").info(LDAP_AUTHENTICATING, (Object)userID);
        boolean isWebAdmin = false;
        if (this.authenticateSpecialUserFunction != null && (isWebAdmin = this.authenticateSpecialUserFunction.apply(userID, password).booleanValue())) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").trace(LDAP_AUTHENTICATION_SUCCESSFUL, (Object)userID);
            return;
        }
        if (password == null || password.length == 0 || String.valueOf(password).trim().isEmpty()) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(LDAP_AUTHENTICATION_FAILED, (Object)userID, (Object)EMPTY_PASSWORD_MESSAGE);
            throw new SecurityException(EMPTY_PASSWORD_MESSAGE);
        }
        if (this.config.getDnPatterns().isEmpty() && !this.config.getManagerDN().isEmpty()) {
            this.authenticateUsingManager(userID, password);
        } else {
            Context context = null;
            Collection<String> userDNList = this.config.getDistinguishedNamesForUser(userID);
            String filter = this.config.getFilter();
            try {
                try {
                    context = new InitialLdapContext(this.buildEnvironment(), null);
                    if (this.config.isTlsEnabled()) {
                        StartTlsResponse tls = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
                        tls.negotiate();
                    }
                    if (!this.canBind((LdapContext)context, userDNList, password, filter)) {
                        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(LDAP_AUTHENTICATION_FAILED, (Object)userID, (Object)AUTHENTICATION_ERROR);
                        throw new SecurityException(AUTHENTICATION_ERROR);
                    }
                }
                catch (IOException | NamingException e) {
                    LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(LDAP_AUTHENTICATION_FAILED, (Object)userID, (Object)ERROR_MESSAGE);
                    throw new SecurityException(ERROR_MESSAGE, e);
                }
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
        LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").trace(LDAP_AUTHENTICATION_SUCCESSFUL, (Object)userID);
    }

    public void authenticateUsingManager(String userID, char[] password) throws SecurityException {
        String userSearchFilter = this.getConfig().getUserSearchFilterForUser(userID);
        if (userSearchFilter == null || userSearchFilter.trim().isEmpty() || this.getConfig().getManagerPassword().isEmpty()) {
            LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").info(LDAP_AUTHENTICATION_FAILED, (Object)userID, (Object)INCOMPLETE_LDAP_CONFIGURATION);
            throw new SecurityException(INCOMPLETE_LDAP_CONFIGURATION);
        }
        InitialContext context = null;
        try {
            try {
                String userSearchBase = this.getConfig().getUserSearchBase();
                context = new InitialDirContext(this.buildSearchEnvironment());
                SearchControls ctrls = new SearchControls();
                ctrls.setSearchScope(2);
                NamingEnumeration<SearchResult> answers = ((InitialDirContext)context).search(userSearchBase, userSearchFilter, ctrls);
                if (!answers.hasMoreElements()) {
                    LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(LDAP_AUTHENTICATION_FAILED, (Object)userID, (Object)LDAP_SEARCH_USER_ERROR);
                    throw new SecurityException(LDAP_SEARCH_USER_ERROR);
                }
                SearchResult result = (SearchResult)answers.nextElement();
                String user = result.getNameInNamespace();
                context.close();
                try {
                    Properties authEnv = new Properties();
                    authEnv.put("java.naming.factory.initial", JNDI_LDAP_CTX_FACTORY);
                    authEnv.put("java.naming.provider.url", this.getConfig().getUrl());
                    authEnv.put("java.naming.security.principal", user);
                    authEnv.put("java.naming.security.credentials", password);
                    context = new InitialDirContext(authEnv);
                }
                catch (AuthenticationException e) {
                    LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(LDAP_AUTHENTICATION_FAILED, (Object)userID, (Object)AUTHENTICATION_ERROR);
                    throw new SecurityException(AUTHENTICATION_ERROR);
                }
            }
            catch (NamingException e) {
                LoggerFactory.getLogger((String)"fr.obeo.dsl.viewpoint.collab.server.security.net4j").error(LDAP_AUTHENTICATION_FAILED, (Object)userID, (Object)ERROR_MESSAGE);
                throw new SecurityException(ERROR_MESSAGE, e);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private boolean canBind(LdapContext context, Collection<String> userDNList, char[] password, String filter) throws NamingException {
        for (String userDN : userDNList) {
            if (!this.canBind(context, userDN, password, filter)) continue;
            return true;
        }
        return false;
    }

    private boolean canBind(LdapContext context, String userDN, char[] password, String filter) throws NamingException {
        boolean canBind = false;
        try {
            this.setCredentials(context, userDN, password);
            context.reconnect(context.getConnectControls());
            canBind = filter != null && !filter.isEmpty() ? this.filterUser(context, userDN, filter) : true;
        }
        catch (AuthenticationException e) {
            canBind = false;
        }
        catch (NamingException e) {
            throw e;
        }
        return canBind;
    }

    private boolean filterUser(LdapContext context, String userDN, String filter) {
        boolean passFilter = false;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> results;
            if (userDN.contains("@")) {
                String[] splitedDN = userDN.split("@");
                String userId = splitedDN[0];
                Object dc = "DC=" + splitedDN[1];
                dc = ((String)dc).replaceAll("\\.", ",DC=");
                results = context.search((String)dc, "(&(sAMAccountName=" + userId + ")(" + filter + "))", constraints);
            } else {
                results = context.search(userDN, filter, constraints);
            }
            if (results != null && results.hasMore()) {
                passFilter = true;
            }
        }
        catch (NamingException e) {
            passFilter = false;
        }
        return passFilter;
    }

    private Properties buildEnvironment() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", JNDI_LDAP_CTX_FACTORY);
        env.put(JAVA_NAMING_LDAP_VERSION, "3");
        env.put(COM_SUN_JNDI_LDAP_CONNECT_TIMEOUT, "10000");
        env.put(COM_SUN_JNDI_DNS_TIMEOUT_INITIAL, "2000");
        env.put(COM_SUN_JNDI_DNS_TIMEOUT_RETRIES, "3");
        env.put("java.naming.provider.url", this.getConfig().getUrl());
        return env;
    }

    private void setCredentials(LdapContext context, String userDN, char[] password) throws NamingException {
        context.addToEnvironment("java.naming.security.authentication", AUTHENTICATION_MODE);
        context.addToEnvironment("java.naming.security.principal", userDN);
        context.addToEnvironment("java.naming.security.credentials", password);
    }

    private void setTrustStore(LDAPAuthenticatorConfig configuration) {
        String propTrustStore;
        String trustStorePath = configuration.getTrustStorePath();
        char[] passphrase = configuration.getTrustStorePassphrase();
        if (trustStorePath != null && (propTrustStore = System.getProperty(JAVAX_NET_SSL_TRUST_STORE)) == null) {
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE, trustStorePath);
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, new String(passphrase));
        }
    }

    public LDAPAuthenticatorConfig getConfig() {
        return this.config;
    }

    public void setConfig(LDAPAuthenticatorConfig config) {
        this.config = config;
    }

    @Override
    public IAuthenticator getAuthenticator() {
        return this;
    }

    private Properties buildSearchEnvironment() {
        String managerPassword;
        Properties env = this.buildEnvironment();
        String managerDN = this.getConfig().getManagerDN();
        if (managerDN != null && !managerDN.isEmpty()) {
            env.put("java.naming.security.principal", managerDN);
        }
        if ((managerPassword = this.getConfig().getManagerPassword()) != null && !managerPassword.isEmpty()) {
            env.put("java.naming.security.credentials", managerPassword);
        }
        return env;
    }

    @Override
    public void setSpecialUserAuthenticator(BiFunction<String, char[], Boolean> isSpecialUserAuthenticator) {
        this.authenticateSpecialUserFunction = isSpecialUserAuthenticator;
    }
}

