/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.server.repository.db.job;

import com.ibm.icu.text.DurationFormat;
import com.ibm.icu.util.ULocale;
import com.thalesgroup.mde.melody.collab.adm.services.utils.FileUtils;
import com.thalesgroup.mde.melody.collab.server.repository.db.Activator;
import com.thalesgroup.mde.melody.collab.server.repository.db.DBRepositoryUtils;
import com.thalesgroup.mde.melody.collab.server.repository.db.job.AbstractJob;
import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.emf.cdo.server.internal.db.DBStore;

public class BackupJob
extends AbstractJob {
    public static final String COLLAB_DB_BACKUP_FOLDER = "collab.db.backupFolder";
    private static final String COLLAB_DB_BACKUP_FREQUENCY_IN_SECONDS = "collab.db.backupFrequencyInSeconds";
    private static final String COLLAB_DB_BACKUP_FOLDER_MAX_SIZE = "collab.db.backupFolderMaxSize";
    private static final int MAX_PERIOD = 16;
    private static final int ALERT_NB_BEFORE_MAX_PERIOD = 5;
    private long period;
    private long periodDefault;
    private long folderMaxSize;
    private long lastFileSize;
    protected StringBuffer filename;
    protected boolean reSchedule = false;
    protected boolean autoSchedule = true;

    public BackupJob(DBStore dbStore) {
        super("Backup " + dbStore.getRepository().getName(), System.getProperty(COLLAB_DB_BACKUP_FOLDER));
        this.init(dbStore);
    }

    public BackupJob(DBStore dbStore, String dbBackupFolder) {
        super("Backup " + dbStore.getRepository().getName(), dbBackupFolder);
        this.init(dbStore);
    }

    private void init(DBStore dbStore) {
        this.dbStore = dbStore;
        this.folderMaxSize = FileUtils.folderMaxSize((String)System.getProperty(COLLAB_DB_BACKUP_FOLDER_MAX_SIZE));
        if (this.folderMaxSize == 0L) {
            this.folderMaxSize = Long.MAX_VALUE;
        }
        this.periodDefault = this.period = DBRepositoryUtils.frequency(System.getProperty(COLLAB_DB_BACKUP_FREQUENCY_IN_SECONDS));
        if (this.period == 0L) {
            this.autoSchedule = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = this.validate();
        if (Status.OK_STATUS.equals(status)) {
            int priority = this.getThread().getPriority();
            try {
                try {
                    this.getThread().setPriority(1);
                    this.period = this.computeBackupFolderRemainingSpace();
                    status = this.process();
                    this.computeBackupFilesSize();
                    String duration = DurationFormat.getInstance((ULocale)ULocale.ENGLISH).formatDurationFromNow(this.period);
                    if (!this.autoSchedule) return status;
                    Activator.getInstance().log(this.getName() + " job will be launched in " + duration);
                    this.schedule(this.period);
                    return status;
                }
                catch (Exception exception_p) {
                    status = new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", this.getName() + " job will fail, please check the folder " + this.folder.getName());
                    Activator.getInstance().getLog().log(status);
                    this.getThread().setPriority(priority);
                }
                return status;
            }
            finally {
                this.getThread().setPriority(priority);
            }
        } else {
            Activator.getInstance().getLog().log(status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus process() {
        Status status = null;
        Object object = exclusiveProcess;
        synchronized (object) {
            Activator.getInstance().log(this.getName() + " processing starts.");
            try {
                DBRepositoryUtils.executeQuery(this.dbStore, "SCRIPT TO '" + this.filename.toString() + "-sql.zip' compression zip");
                String statusMessage = this.getName() + " created the file " + this.filename.toString() + "-sql.zip";
                Activator.getInstance().log(statusMessage);
                status = new Status(0, "com.thalesgroup.mde.melody.collab.server.repository.h2", statusMessage);
            }
            catch (SQLException exception_p) {
                String statusMessage = this.getName() + " process failed while running SCRIPT TO command";
                Activator.getInstance().logError(statusMessage, exception_p);
                status = new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", statusMessage, (Throwable)exception_p);
            }
            Activator.getInstance().log(this.getName() + " processing ends.");
        }
        return status;
    }

    private void computeBackupFilesSize() {
        File file = new File(this.filename.toString() + "-sql.zip");
        this.lastFileSize = file.length();
    }

    @Override
    protected IStatus validate() {
        IStatus status = super.validate();
        if (this.autoSchedule && this.folderMaxSize == 0L) {
            String message = "Impossible to launch the job " + this.getName() + ": no folder maximum size specified: Please check the property collab.db.backupFolderMaxSize in .ini file in installation directory";
            status = new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", message);
        }
        return status;
    }

    @Override
    public void done(IJobChangeEvent event) {
        super.done(event);
        try {
            long newPeriod = this.computeBackupFolderRemainingSpace();
            if (this.reSchedule || newPeriod < this.period) {
                this.reSchedule = false;
                this.period = newPeriod;
                String duration = DurationFormat.getInstance((ULocale)ULocale.ENGLISH).formatDurationFromNow(this.period);
                if (this.autoSchedule) {
                    Activator.getInstance().log(this.getName() + " job has detected new free space in the backup folder, it will be restarted in " + duration);
                    this.cancel();
                    this.schedule(this.period);
                }
            }
        }
        catch (Exception exception_p) {
            Activator.getInstance().logError("Next " + this.getName() + " job will fail, please check the folder " + this.folder.getName());
            this.reSchedule = true;
        }
    }

    protected synchronized long computeBackupFolderRemainingSpace() throws Exception {
        this.filename = new StringBuffer(this.folder.getAbsolutePath());
        this.filename.append(this.folder.getName().endsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator"));
        this.filename.append(this.dbStore.getRepository().getName());
        long folderSize = this.folderWatcher.getFolderSize();
        int newAlert = 0;
        while (folderSize + (long)(5 - newAlert) * this.lastFileSize > this.folderMaxSize && newAlert < 5) {
            ++newAlert;
        }
        if (newAlert > 0) {
            String message = null;
            if (newAlert < 5) {
                this.filename.append(".").append(this.dateFormat.format(new Date()));
                message = this.getName() + " job will reach the specified maxium size for the backup folder! (" + this.folderMaxSize + " bytes) in the next " + (5 - newAlert) + " backup process. Please clean the folder " + this.folder.getName() + ".";
            } else {
                message = this.getName() + " job has reached the maximum size for the backup folder! (" + this.folderMaxSize + " bytes). The files " + this.filename.toString() + "-sql.zip will be replaced! Please clean the folder " + this.folder.getName() + ".";
            }
            Activator.getInstance().logError(message);
        } else {
            this.filename.append(".").append(this.dateFormat.format(new Date()));
        }
        long newPeriod = this.periodDefault;
        if (newAlert > 0) {
            newPeriod = (long)(5.76E7 / Math.pow(2.0, 5 - newAlert));
        }
        return newPeriod;
    }
}

