#!/bin/sh
#
# Team for Capella Command console
#
# each option can also be added directly on the commandline: e.g. "command.sh -command capella_db -commandParams backup"
# Syntax:
# command.bat -command [command] -commandParams [command_parameters]
# [command] value: the name of the command
# [command_parameters] value: defines the parameters to provide to the command, they must be separated by a white space character. If the parameter contains a white character (ex : a path), use the quotes (ex : command "C:\my path")
#
# Sample commands:
# - Stop the server asking for confirmation :                        command.sh -command close
# - Stop the server asynchronously without asking for confirmation : command.sh -command cdo -commandParams stopserver
# - Backup the database server to the specified folder:              command.sh -command capella_db -commandParams backup,"C:\db.backup.folder"
#
# Communication with server using https
#   - switch httpPort to server https port (default: 8443): -httpPort 8443
#   - trusted certificate: 
#      - simply switch the httpsConnection parameter to true: -httpsConnection true
#   - self-signed certificate: 
#      - switch the httpsConnection parameter to true: -httpsConnection true
#      - complete  -vmargs with -Dfr.obeo.dsl.viewpoint.collab.https.jetty.ssl.context.trustall=true
#      - or install your certificate in the JVM
#
# Http credentials can be passed through several ways:
#   - (default) registered in the secure storage, see Scheduler jobs and/or toolsCredentials.sh
#   - as program arguments -httpLogin admin and -httpPassword token_value
#   - in a properties file referenced from program arguments with -httpCredentials httpCredentials.properties

cd ../capella

# Communication with server using http
./capella \
--launcher.suppressErrors \
-nosplash -console -consoleLog \
-data command-workspace \
-application fr.obeo.dsl.viewpoint.collab.tools.command \
-httpHost localhost \
-httpPort 8080 \
-httpsConnection false \
"$@" \
-vmargs -Xms1000m -Xmx3000m -Xss4m \
-XX:+UseG1GC -XX:+UseStringDeduplication \
-Dorg.eclipse.net4j.util.om.trace.disable=true \
-Dosgi.requiredJavaVersion=17 \
-Dosgi.dataAreaRequiresExplicitInit=true \
-Dlogback.configurationFile=configuration/logback.xml \
-Dpde.jreProfile=JavaSE-17
