#!/bin/sh
#
# Team for Capella Repository Maintenance
#
# Communication with server using https
#   - switch httpPort to server https port (default: 8443): -httpPort 8443
#   - trusted certificate: 
#      - simply switch the httpsConnection parameter to true: -httpsConnection true
#   - self-signed certificate: 
#      - switch the httpsConnection parameter to true: -httpsConnection true
#      - complete  -vmargs with -Dfr.obeo.dsl.viewpoint.collab.https.jetty.ssl.context.trustall=true
#      - or install your certificate in the JVM
#
# Http credentials can be passed through several ways:
#   - (default) registered in the secure storage, see Scheduler jobs and/or toolsCredentials.sh
#   - as program arguments -httpLogin admin and -httpPassword token_value
#   - in a properties file referenced from program arguments with -httpCredentials httpCredentials.properties

cd ../capella


# Communication with server using http
./capella \
--launcher.suppressErrors \
-nosplash -console -consoleLog \
-data maintenance-workspace \
-application com.thalesgroup.mde.melody.collab.maintenance \
-repositoryCredentials ../tools/repositoryCredentials.properties \
-httpHost localhost \
-httpPort 8080 \
-httpsConnection false \
"$@" \
-vmargs -Xms1000m -Xmx3000m -Xss4m \
-XX:+UseG1GC -XX:+UseStringDeduplication \
-Dorg.eclipse.net4j.util.om.trace.disable=true \
-Dosgi.requiredJavaVersion=17 \
-Dosgi.dataAreaRequiresExplicitInit=true \
-Dlogback.configurationFile=configuration/logback.xml \
-Dpde.jreProfile=JavaSE-17
