#!/bin/sh
#
# Team for Capella Tools Credentials
#
# Documentation is available :
# * in T4C documentation in "Jenkins Configuration" chapter
# * typing repositoryCredentials -help (see result in log)
#
# Each option can also be added directly on the commandline: e.g. "toolsCredentials.sh -hostname localhost -port 2036 -reponame repoCapella -repositoryLogin importerUser -repositoryPassword importerPassword"

cd ../capella

./capella \
--launcher.suppressErrors \
-nosplash -console -consoleLog \
-data tools-workspace \
-application fr.obeo.dsl.viewpoint.collab.tools.credentials \
"$@" \
-vmargs -Xms1000m -Xmx3000m -Xss4m \
-XX:+UseG1GC -XX:+UseStringDeduplication \
-Dorg.eclipse.net4j.util.om.trace.disable=true \
-Dosgi.requiredJavaVersion=17 \
-Dosgi.dataAreaRequiresExplicitInit=true \
-Dlogback.configurationFile=configuration/logback.xml \
-Dpde.jreProfile=JavaSE-17
