/*******************************************************************************
 * Copyright (c) 2024 THALES GLOBAL SERVICES.
 * All rights reserved.
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.commit;

import fr.obeo.dsl.viewpoint.collab.common.internal.Activator;

/**
 * Utility class providing facilities for dealing with CDO Commit comments.
 */
public final class CommitCommentUtil {

    /**
     * CommitCommentUtil constructor.
     */
    private CommitCommentUtil() {

    }

    /**
     * Return a commit description that does not exceed the maximum length, given by the property
     * "fr.obeo.dsl.viewpoint.collab.common.commit.description.max.length". If the commit message is longer then it is
     * truncated and ends with " [...]".
     * 
     * @param commitDescription
     *            the commit message to process
     * @return a commit message that respect the maximum length
     */
    public static String fitCommitDescriptionLength(String commitDescription) {
        int maxLength = Integer.getInteger(Activator.COMMIT_DESCRIPTION_MAX_LENGTH, Activator.COMMIT_DESCRIPTION_DEFAULT_MAX_LENGTH);

        // -1 means no limitation (dialog will be configured with the SWT widget Text.Limit system dependent value
        // Values from 0 to 9 are not accepted: Xxxxxxxxxx -> Xxxx [...]
        if (maxLength >= 10 && commitDescription != null && commitDescription.length() > maxLength) {
            return commitDescription.substring(0, maxLength - 6) + " [...]"; //$NON-NLS-1$
        }
        return commitDescription;
    }

}
