/*******************************************************************************
 * Copyright (c) 2022 THALES GLOBAL SERVICES and others.
 * All rights reserved.
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Represents the user authentication information for the admin web server.
 * 
 * @author fbarbin
 *
 */
public class SecureStorageAdminAuthenticationInfo {

    private String userID;

    private Map<String, char[]> tokens;

    private boolean isAdmin;

    /**
     * Default construtor.
     * 
     * @param userID
     *            user ID.
     * @param password
     *            the user password.
     * @param isAdmin
     *            whether the user has admin privileges or not.
     */
    public SecureStorageAdminAuthenticationInfo(String userID, boolean isAdmin, Map<String, char[]> tokens) {
        this.userID = Objects.requireNonNull(userID);
        this.isAdmin = isAdmin;
        this.tokens = new HashMap<>(Objects.requireNonNull(tokens));
    }

    public String getUserID() {
        return userID;
    }

    public boolean isAdmin() {
        return isAdmin;
    }

    public Map<String, char[]> getTokens() {
        return new HashMap<>(tokens);
    }
}
