/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.http;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.http.AbstractAuthenticationResultResource;
import javax.servlet.http.HttpServletRequest;

public class AuthenticationFailResource
extends AbstractAuthenticationResultResource {
    public static final String ALIAS = "/auth/fail";
    private static final long serialVersionUID = -5880708405196385329L;
    private static final String CONNECTEDUSER_LOGOUT_ADDITION = "<div class=\"user-info\">You are connected as CONNECTED_USER. <span><a href=\"OIDC_SIGNOUT_REQUEST_URL\" shape=\"rect\">Log out</a></span></div>";
    private static final String NOT_ALLOWED_REPOSITORY_ADDITIONS = "<div class=\"user-error\">You are not allowed to access the repository \"REPOSITORY_NAME\".</div>";
    private static final String MESSAGE_ADDITIONS = "<div class=\"user-error\">MESSAGE</div>";
    private static final String ERROR_ADDITIONS = "<table><tbody><tr><td class=\"label\">Error:</td><td class=\"value\"><code>ERROR</code></td></tr><tr><td class=\"label\">Description:</td><td class=\"value\">ERROR_DESCRIPTION</td></tr><tr><td class=\"label\">More Info:</td><td class=\"value\">ERROR_URI</td></tr></tbody></table>";
    private static final String N_A = "n/a";
    private static final String ERROR = "ERROR";
    private static final String ERROR_DESCRIPTION = "ERROR_DESCRIPTION";
    private static final String ERROR_URI = "ERROR_URI";
    private static final String ERROR_MESSAGE = "MESSAGE";

    @Override
    protected String getHtmlFileName() {
        return "resources/auth/fail.html";
    }

    @Override
    protected String updateHTML(HttpServletRequest req, String htmlLine) {
        if (req.getRequestURI().startsWith(ALIAS) && htmlLine.contains("<div class=\"error-details\" hidden>")) {
            String error;
            Object additions = "";
            Object modifiedHtmlLine = htmlLine;
            String userFromCookie = this.getUserFromCookie(req);
            if (!StringUtil.isEmpty((String)userFromCookie)) {
                additions = CONNECTEDUSER_LOGOUT_ADDITION;
                additions = this.replaceConnectedUser(req, (String)additions);
                additions = this.replaceSignout(req, (String)additions);
                String repositoryNameFromCookie = this.getRepositoryNameFromCookie(req);
                if (!StringUtil.isEmpty((String)repositoryNameFromCookie)) {
                    additions = (String)additions + this.replaceRepositoryName(req, NOT_ALLOWED_REPOSITORY_ADDITIONS);
                }
            }
            if (!StringUtil.isEmpty((String)(error = req.getParameter("error")))) {
                additions = (String)additions + this.replaceMessage(req, MESSAGE_ADDITIONS);
                modifiedHtmlLine = "<div class=\"error-details\">";
                modifiedHtmlLine = (String)modifiedHtmlLine + String.valueOf(this.replaceError(req, ERROR_ADDITIONS));
            }
            return (String)additions + (String)modifiedHtmlLine;
        }
        return htmlLine;
    }

    private String replaceMessage(HttpServletRequest req, String htmlLine) {
        String errorParam = req.getParameter("message");
        if (!StringUtil.isEmpty((String)errorParam)) {
            String returnedHtmlLine = htmlLine;
            returnedHtmlLine = returnedHtmlLine.replaceFirst(ERROR_MESSAGE, errorParam);
        }
        return "";
    }

    private Object replaceError(HttpServletRequest req, String htmlLine) {
        String returnedHtmlLine = htmlLine;
        String errorParam = req.getParameter("error");
        String error = StringUtil.isEmpty((String)errorParam) ? N_A : errorParam;
        returnedHtmlLine = returnedHtmlLine.replaceFirst(ERROR, error);
        errorParam = req.getParameter("error_description");
        String errorDescription = StringUtil.isEmpty((String)errorParam) ? N_A : errorParam;
        returnedHtmlLine = returnedHtmlLine.replaceFirst(ERROR_DESCRIPTION, errorDescription);
        errorParam = req.getParameter("error_uri");
        String errorURI = StringUtil.isEmpty((String)errorParam) ? N_A : errorParam;
        returnedHtmlLine = returnedHtmlLine.replaceFirst(ERROR_URI, errorURI);
        return returnedHtmlLine;
    }
}

