/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.signal;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import java.net.URL;
import java.util.Optional;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.PluginRepositoryProvider;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class GetOpenIDAuthenticationInfoIndication
extends IndicationWithResponse {
    private String repositoryName;

    public GetOpenIDAuthenticationInfoIndication(SignalProtocol<?> protocol) {
        super(protocol, (short)202);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        this.repositoryName = in.readString();
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        IRepository repository = PluginRepositoryProvider.INSTANCE.getRepository(this.repositoryName);
        if (repository == null) {
            throw new IllegalArgumentException("The repository " + this.repositoryName + " does not exist");
        }
        Optional<OpenIDAuthenticator> openIDAuthenticator = OpenIdConnectUtil.getOpenIdAuthenticator(repository);
        out.writeBoolean(openIDAuthenticator.isPresent());
        if (openIDAuthenticator.isPresent()) {
            boolean authenticationCodeFlow = "code".equalsIgnoreCase(openIDAuthenticator.get().getConfig().getResponseType());
            out.writeBoolean(authenticationCodeFlow);
            if (authenticationCodeFlow) {
                out.writeString(openIDAuthenticator.get().getConfig().getResponseType());
                out.writeString(openIDAuthenticator.get().getConfig().getClientID());
                out.writeString(openIDAuthenticator.get().getConfig().getScope());
                out.writeString(openIDAuthenticator.get().getConfig().getAcrValues());
                out.writeString(openIDAuthenticator.get().getConfig().getComplement());
                out.writeString(openIDAuthenticator.get().getConfig().getAuthorizationtEndPointURI());
                out.writeString(openIDAuthenticator.get().getConfig().getTokenEndPointURI());
                out.writeString(openIDAuthenticator.get().getConfig().getJwksURI());
                out.writeString(openIDAuthenticator.get().getConfig().getIssuerURI());
                out.writeString(openIDAuthenticator.get().getConfig().getUserInfoEndPointURI());
                out.writeString(openIDAuthenticator.get().getConfig().getUserInfoPayload());
                out.writeString(openIDAuthenticator.get().getConfig().getUserInfoMatchClaim());
                out.writeInt(openIDAuthenticator.get().getConfig().getLoginTimeoutMS());
                out.writeString(openIDAuthenticator.get().getConfig().getLoopbackServerName());
                out.writeInt(openIDAuthenticator.get().getConfig().getLoopbackServerPort());
            } else {
                String overriddenCommonUrl = openIDAuthenticator.get().getConfig().getImplicitFlowWebServerURL();
                if (!StringUtil.isEmpty((String)overriddenCommonUrl)) {
                    URL url = new URL(overriddenCommonUrl);
                    boolean isHttps = "https".equals(url.getProtocol());
                    int port = url.getPort();
                    if (port == -1) {
                        port = url.getDefaultPort();
                    }
                    out.writeBoolean(isHttps);
                    out.writeInt(port);
                } else {
                    AdminServerConfigurationHelper adminServerConfigurationHelper = AdminServerConfigurationHelper.getInstance();
                    boolean httpsEnabled = adminServerConfigurationHelper.isHttpsEnabled();
                    int port = httpsEnabled ? adminServerConfigurationHelper.getHttpsPort() : adminServerConfigurationHelper.getHttpPort();
                    out.writeBoolean(httpsEnabled);
                    out.writeInt(port);
                }
            }
        }
    }
}

