/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.factory;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.IFactoryKey;

public final class FactoryKey
implements IFactoryKey,
Serializable,
Comparable<FactoryKey> {
    private static final long serialVersionUID = 1L;
    private String productGroup;
    private String type;

    public FactoryKey(String productGroup, String type) {
        CheckUtil.checkArg(!StringUtil.isEmpty(productGroup), "productGroup is empty");
        this.productGroup = productGroup;
        this.type = type;
    }

    @Override
    public String getProductGroup() {
        return this.productGroup;
    }

    public void setProductGroup(String productGroup) {
        this.productGroup = productGroup;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FactoryKey) {
            FactoryKey key = (FactoryKey)obj;
            return ObjectUtil.equals(this.productGroup, key.productGroup) && ObjectUtil.equals(this.type, key.type);
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtil.hashCode(this.productGroup) ^ ObjectUtil.hashCode(this.type);
    }

    public String toString() {
        return MessageFormat.format("{0}[{1}]", this.productGroup, this.type);
    }

    @Override
    public int compareTo(FactoryKey key) {
        int result = StringUtil.compare(this.productGroup, key.productGroup);
        if (result == 0) {
            result = StringUtil.compare(this.type, key.type);
        }
        return result;
    }
}

