/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.log.bridge;

import com.thalesgroup.mde.melody.collab.log.bridge.LogListenerBridge;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "com.thalesgroup.mde.melody.collab.log.bridge";
    private static final Logger logger = LoggerFactory.getLogger((String)"com.thalesgroup.mde.melody.collab.log.bridge");
    private static BundleContext context;
    private ServiceTracker<LogReaderService, LogReaderService> logReaderServiceTracker;
    private LogListener logListener;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.startJULBridge();
        this.startEclipseBridge();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.endEclipseBridge();
        context = null;
    }

    private void startJULBridge() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        logger.debug("SLF4JBridgeHandler started");
    }

    private void startEclipseBridge() {
        this.logReaderServiceTracker = new ServiceTracker(context, LogReaderService.class, null);
        this.logReaderServiceTracker.open();
        LogReaderService logReaderService = (LogReaderService)this.logReaderServiceTracker.getService();
        if (logReaderService != null) {
            this.logListener = new LogListenerBridge();
            logReaderService.addLogListener(this.logListener);
        }
    }

    private void endEclipseBridge() {
        if (this.logListener != null) {
            LogReaderService logReaderService = (LogReaderService)this.logReaderServiceTracker.getService();
            if (logReaderService != null) {
                logReaderService.removeLogListener(this.logListener);
            }
            this.logListener = null;
        }
        if (this.logReaderServiceTracker != null) {
            this.logReaderServiceTracker.close();
            this.logReaderServiceTracker = null;
        }
    }
}

