/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.log.bridge;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogListenerBridge
implements LogListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.thalesgroup.mde.melody.collab.log.bridge");

    LogListenerBridge() {
    }

    public void logged(LogEntry entry) {
        Bundle entryBundle = entry.getBundle();
        String entryBundleName = entryBundle == null ? null : entryBundle.getSymbolicName();
        String entryMessage = entry.getMessage();
        long entryTime = entry.getTime();
        ServiceReference entryService = entry.getServiceReference();
        String entryServiceName = entryService == null ? null : entryService.toString();
        LogLevel entryLogLevel = entry.getLogLevel();
        Throwable entryException = entry.getException();
        if (logger.isDebugEnabled()) {
            if (entryServiceName != null) {
                logger.debug("logged from Bundle [{}] with message [{}] time [{}] - ServiceReference [{}]", new Object[]{entryBundleName, entryMessage, entryTime, entryServiceName});
            } else {
                logger.debug("logged from Bundle [{}] with message [{}] time [{}]", new Object[]{entryBundleName, entryMessage, entryTime});
            }
        }
        Logger entryLogger = entryBundleName != null ? LoggerFactory.getLogger((String)entryBundleName) : LoggerFactory.getLogger((String)"com.thalesgroup.mde.melody.collab.log.bridge.osgi_generic");
        String finalMessage = entryMessage;
        if (entryServiceName != null) {
            finalMessage = String.format("Service: %1$ - %2$", entryServiceName, entryMessage);
        }
        LogListenerBridge.logLogEntry(entryLogger, entryLogLevel, finalMessage, entryException);
    }

    private static void logLogEntry(Logger logger, LogLevel level, String message, Throwable e) {
        if (e == null) {
            switch (level) {
                case DEBUG: {
                    logger.debug(message);
                    break;
                }
                case TRACE: {
                    logger.trace(message);
                    break;
                }
                case ERROR: {
                    logger.error(message);
                    break;
                }
                case WARN: {
                    logger.warn(message);
                    break;
                }
                default: {
                    logger.info(message);
                    break;
                }
            }
        } else {
            switch (level) {
                case DEBUG: {
                    logger.debug(message, e);
                    break;
                }
                case TRACE: {
                    logger.trace(message, e);
                    break;
                }
                case ERROR: {
                    logger.error(message, e);
                    break;
                }
                case WARN: {
                    logger.warn(message, e);
                    break;
                }
                default: {
                    logger.info(message, e);
                }
            }
        }
    }
}

