/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.services.durablelock;

import com.thalesgroup.mde.melody.collab.adm.common.locks.CDOLockAreaBuffer;
import com.thalesgroup.mde.melody.collab.adm.services.durablelock.LockServices;
import com.thalesgroup.mde.melody.collab.adm.services.utils.CollabAdminServices;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.server.ILockingManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public class DurableLockServices {
    public static void deleteLock(String repoName, String lockId, CDOTransaction transaction) {
        IRepository repository = CollabAdminServices.getRepository(repoName);
        if (repository != null) {
            ILockingManager lockManager = repository.getLockingManager();
            try {
                IStoreAccessor accessor = repository.getStore().getWriter(null);
                StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
                LockServices.deleteLocks(transaction);
                lockManager.deleteLockArea(lockId);
            }
            finally {
                StoreThreadLocal.release();
            }
        }
    }

    public static CDOLockAreaBuffer getLock(String repositoryName, String lockId) {
        CDOLockAreaBuffer result = null;
        IRepository repository = CollabAdminServices.getRepository(repositoryName);
        if (repository != null) {
            ILockingManager lockManager = repository.getLockingManager();
            try {
                IStoreAccessor accessor = repository.getStore().getWriter(null);
                StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
                IDurableLockingManager.LockArea area = lockManager.getLockArea(lockId);
                result = CDOLockAreaBuffer.dump((IDurableLockingManager.LockArea)area, (String)repositoryName);
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return result;
    }

    public static Collection<CDOLockAreaBuffer> getLocks(String repositoryName) {
        return DurableLockServices.getLocks(repositoryName, "", true);
    }

    public static Collection<CDOLockAreaBuffer> getLocks(final String repositoryName, String userID, boolean filterLocksOnDeletedObjects) {
        InternalLockManager lockingManager;
        final HashSet<CDOLockAreaBuffer> results = new HashSet<CDOLockAreaBuffer>();
        InternalRepository repository = (InternalRepository)CollabAdminServices.getRepository(repositoryName);
        if (repository != null) {
            lockingManager = repository.getLockingManager();
            try {
                IStoreAccessor accessor = repository.getStore().getWriter(null);
                StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
                IDurableLockingManager.LockArea.Handler handler = new IDurableLockingManager.LockArea.Handler(){

                    public boolean handleLockArea(IDurableLockingManager.LockArea area) {
                        if (area != null) {
                            results.add(CDOLockAreaBuffer.dump((IDurableLockingManager.LockArea)area, (String)repositoryName));
                        }
                        return true;
                    }
                };
                lockingManager.getLockAreas(userID, handler);
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        if (filterLocksOnDeletedObjects) {
            lockingManager = repository.getLockingManager();
            for (CDOLockAreaBuffer buffer : results) {
                Iterator iterator = buffer.getLocks().entrySet().iterator();
                while (iterator.hasNext()) {
                    RWOLockManager.LockState lockState;
                    Map.Entry entry = iterator.next();
                    Object lockKey = lockingManager.getLockKey((CDOID)entry.getKey(), (CDOBranch)repository.getBranchManager().getBranch(buffer.getBranchID()));
                    if (lockKey == null) {
                        iterator.remove();
                    }
                    if ((lockState = lockingManager.getLockState(lockKey)) != null) continue;
                    iterator.remove();
                }
            }
        }
        return results;
    }

    public static String getUserId(String repositoryName, String durableLockingId) {
        IRepository repository = CollabAdminServices.getRepository(repositoryName);
        if (repository == null) {
            return "";
        }
        ILockingManager lockingManager = repository.getLockingManager();
        if (lockingManager == null) {
            return "";
        }
        IStoreAccessor accessor = repository.getStore().getReader(null);
        StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
        try {
            IDurableLockingManager.LockArea lockArea = lockingManager.getLockArea(durableLockingId);
            if (lockArea == null) {
                return "";
            }
            String string = lockArea.getUserID();
            return string;
        }
        finally {
            StoreThreadLocal.release();
        }
    }
}

