/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.services.utils;

import com.thalesgroup.mde.melody.collab.adm.services.utils.CollabAdminServices;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;

public class AdminCDOSession {
    protected IConnector connector = null;
    protected IPasswordCredentialsProvider credentialsProvider = null;
    protected CDONet4jSession session = null;
    protected CDOTransaction transaction = null;
    protected String repositoryName = null;

    public AdminCDOSession(IConnector connector, String repositoryName) {
        this.repositoryName = repositoryName;
        this.connector = connector;
        this.session = this.getSession(connector);
    }

    public AdminCDOSession(IConnector connector, String repositoryName, IPasswordCredentialsProvider credentialProvider) {
        this.repositoryName = repositoryName;
        this.connector = connector;
        this.credentialsProvider = credentialProvider;
        this.session = this.getSession(connector);
    }

    public AdminCDOSession(String repositoryName) {
        this.repositoryName = repositoryName;
        this.connector = this.getConnector();
        this.session = this.getSession(this.connector);
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
    }

    public CDOTransaction getTransaction() {
        if (this.transaction == null) {
            this.transaction = AdminCDOSession.getTransaction(this.getSession());
        }
        return this.transaction;
    }

    public CDOTransaction getTransaction(String durableLockId) {
        if (this.transaction == null) {
            this.transaction = AdminCDOSession.getTransaction(this.getSession(), durableLockId);
        } else {
            System.out.println("Transaction has already been opened.");
        }
        return this.transaction;
    }

    public CDONet4jSession getSession() {
        if (this.session == null) {
            this.session = this.getSession(this.getConnector());
        }
        return this.session;
    }

    public void cleanUp() {
        AdminCDOSession.cleanUp(this.connector, this.session, (CDOView)this.transaction);
    }

    public static CDOView getView(CDONet4jSession session) {
        return session.openView();
    }

    public static CDOTransaction getTransaction(CDONet4jSession session) {
        try {
            return session.openTransaction();
        }
        catch (IllegalStateException exception) {
            System.out.println(exception.getMessage());
            throw exception;
        }
    }

    public static CDOTransaction getTransaction(CDONet4jSession session, String durableLockId) {
        try {
            return session.openTransaction(durableLockId);
        }
        catch (IllegalStateException exception) {
            System.out.println(exception.getMessage());
            throw exception;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CDONet4jSession getSession(IConnector connector) {
        CDONet4jSessionConfiguration sessionConfiguration = CDONet4jUtil.createNet4jSessionConfiguration();
        sessionConfiguration.setConnector(connector);
        sessionConfiguration.setRepositoryName(this.repositoryName);
        if (this.credentialsProvider != null) {
            sessionConfiguration.setCredentialsProvider(this.credentialsProvider);
        }
        return sessionConfiguration.openNet4jSession();
    }

    public IConnector getConnector() {
        if (this.connector == null) {
            IPluginContainer container = CollabAdminServices.getPluginContainer();
            Net4jUtil.prepareContainer((IManagedContainer)container);
            JVMUtil.prepareContainer((IManagedContainer)container);
            CDONet4jUtil.prepareContainer((IManagedContainer)container);
            if (!container.isActive()) {
                container.activate();
            }
            this.connector = JVMUtil.getConnector((IManagedContainer)container, (String)"default");
        }
        return this.connector;
    }

    private static void cleanUp(IConnector connector, CDONet4jSession session, CDOView view) {
        try {
            if (view != null) {
                view.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (connector != null) {
                connector.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

