/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.oo15oo.oo179oo.oo6083oo;

import fr.obeo.oo15oo.oo179oo.oo6083oo.Oo43177oo;
import fr.obeo.oo15oo.oo179oo.oo6083oo.Oo44946oo;
import fr.obeo.oo15oo.oo179oo.oo6083oo.SocketConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ServerSocketFactory;

public class Oo43175oo {
    private int port = 9999;
    private Oo43177oo logger = Oo43177oo.DEFAULT;
    private int maxConnections = -1;
    private Oo44946oo executor;
    private ServerSocket serverSocket;
    private final AtomicBoolean shutdownFromOtherThread = new AtomicBoolean();

    public Oo43175oo() {
        this.logger = Oo43177oo.DEFAULT;
    }

    public Oo43175oo setPort(int newPort) {
        this.port = newPort;
        return this;
    }

    public Oo43175oo setLogger(Oo43177oo logger) {
        this.logger = logger;
        return this;
    }

    public Oo43177oo getLogger() {
        return this.logger;
    }

    public Oo43175oo setExecutor(Oo44946oo executor) {
        this.executor = executor;
        return this;
    }

    public Oo44946oo getExecutor() {
        return this.executor;
    }

    public Oo43175oo setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public void startListening() throws IOException {
        this.logger.info("Server initialized, listening for clients on port:" + this.port);
        this.serverSocket = null;
        Socket oo7522oo = null;
        try {
            try {
                this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(this.port);
                while (!this.executor.isShutdown() && this.executor.canAcceptNewConnections() && !this.serverSocket.isClosed()) {
                    oo7522oo = this.serverSocket.accept();
                    this.logger.debug("Connection received from IP:" + String.valueOf(oo7522oo.getInetAddress()));
                    this.executor.execute(new SocketConnection(oo7522oo), this.logger);
                }
                this.logger.info("Shutting down the server");
            }
            catch (SocketException e) {
                if (!this.shutdownFromOtherThread.get()) {
                    throw e;
                }
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException e2) {
                        this.logger.error(e2.getMessage());
                        e2.printStackTrace();
                    }
                }
                if (this.executor != null) {
                    this.executor.shutdown();
                }
            }
        }
        finally {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                    e.printStackTrace();
                }
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
    }

    public void stopListening() throws InterruptedException, IOException {
        if (this.executor != null) {
            this.executor.shutdown(5000);
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.shutdownFromOtherThread.set(true);
                this.serverSocket.close();
            }
            this.executor = null;
        }
    }
}

