/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.activity.model.api.activitymetadata;

import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivityMetadataExport;
import fr.obeo.dsl.viewpoint.collab.activity.model.activitymetadata.ActivitymetadataFactory;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Objects;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.session.CDOSession;

public interface CommitMetadataExporter {
    public static final DateTimeFormatter ZONED_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    default public ActivityMetadataExport export(CDOCommitInfo from, CDOCommitInfo to, boolean exportChanges) {
        return this.export(from, to, exportChanges, false);
    }

    public ActivityMetadataExport export(CDOCommitInfo var1, CDOCommitInfo var2, boolean var3, boolean var4);

    default public ActivityMetadataExport export(CDOSession cdoSession, Instant from, Instant to, boolean exportChanges) {
        return this.export(cdoSession, from, to, exportChanges, false);
    }

    default public ActivityMetadataExport export(CDOSession cdoSession, Instant from, Instant to, boolean exportChanges, boolean computeImpactedRepresentations) {
        Objects.requireNonNull(cdoSession);
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        CDOCommitInfoManager commitInfoManager = cdoSession.getCommitInfoManager();
        CDOBranch mainBranch = cdoSession.getBranchManager().getMainBranch();
        return this.export(commitInfoManager, mainBranch, from, to, exportChanges, computeImpactedRepresentations);
    }

    default public ActivityMetadataExport export(CDOCommitInfoManager commitInfoManager, CDOBranch branch, Instant from, Instant to, boolean exportChanges, boolean computeImpactedRepresentations) {
        Objects.requireNonNull(commitInfoManager);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Instant repoCreation = new Date(commitInfoManager.getRepository().getCreationTime()).toInstant();
        Instant lastCommit = CommitMetadataExporter.getHeadInstant(commitInfoManager, branch);
        final CDOCommitInfo[] fromCommit = new CDOCommitInfo[1];
        final CDOCommitInfo[] toCommit = new CDOCommitInfo[1];
        if (!(!Instant.EPOCH.equals(from) && from.isAfter(lastCommit) || !Instant.EPOCH.equals(to) && to.isBefore(repoCreation))) {
            Instant safeFrom = CommitMetadataExporter.getSafeInstant(from, repoCreation, lastCommit);
            Instant safeTo = CommitMetadataExporter.getSafeInstant(to, repoCreation, lastCommit);
            if (safeTo.equals(safeFrom) || safeTo.isAfter(safeFrom)) {
                commitInfoManager.getCommitInfos(branch, Date.from(safeFrom).getTime(), Date.from(safeTo).getTime(), new CDOCommitInfoHandler(){

                    public void handleCommitInfo(CDOCommitInfo commitInfo) {
                        if (fromCommit[0] == null || fromCommit[0].getTimeStamp() > commitInfo.getTimeStamp()) {
                            fromCommit[0] = commitInfo;
                        }
                        if ((toCommit[0] == null || toCommit[0].getTimeStamp() < commitInfo.getTimeStamp()) && commitInfo.getPreviousTimeStamp() > 0L) {
                            toCommit[0] = commitInfo;
                        }
                    }
                });
            }
        }
        if (fromCommit[0] == null) {
            ActivityMetadataExport result = ActivitymetadataFactory.eINSTANCE.createActivityMetadataExport();
            result.setFrom(Date.from(Instant.EPOCH.equals(from) ? lastCommit : from));
            result.setTo(Date.from(Instant.EPOCH.equals(to) ? lastCommit : to));
            return result;
        }
        return this.export(fromCommit[0], toCommit[0], exportChanges, computeImpactedRepresentations);
    }

    default public ActivityMetadataExport exportToHead(CDOSession cdoSession, Instant from, boolean exportChanges) {
        return this.exportToHead(cdoSession, from, exportChanges, false);
    }

    default public ActivityMetadataExport exportToHead(CDOSession cdoSession, Instant from, boolean exportChanges, boolean computeImpactedRepresentations) {
        Objects.requireNonNull(cdoSession);
        Objects.requireNonNull(from);
        CDOCommitInfoManager commitInfoManager = cdoSession.getCommitInfoManager();
        CDOBranch mainBranch = cdoSession.getBranchManager().getMainBranch();
        Instant lastCommit = CommitMetadataExporter.getHeadInstant(commitInfoManager, mainBranch);
        return this.export(cdoSession, from, lastCommit, exportChanges, computeImpactedRepresentations);
    }

    default public ActivityMetadataExport exportAll(CDOSession cdoSession, boolean exportChanges) {
        return this.exportAll(cdoSession, exportChanges, false);
    }

    default public ActivityMetadataExport exportAll(CDOSession cdoSession, boolean exportChanges, boolean computeImpactedRepresentations) {
        Objects.requireNonNull(cdoSession);
        CDOCommitInfoManager commitInfoManager = cdoSession.getCommitInfoManager();
        Instant from = new Date(commitInfoManager.getRepository().getCreationTime()).toInstant();
        CDOBranch mainBranch = cdoSession.getBranchManager().getMainBranch();
        Instant last = CommitMetadataExporter.getHeadInstant(commitInfoManager, mainBranch);
        return this.export(cdoSession, from, last, exportChanges, computeImpactedRepresentations);
    }

    default public ActivityMetadataExport exportTo(CDOSession cdoSession, Instant to, boolean exportChanges) {
        return this.exportTo(cdoSession, to, exportChanges, false);
    }

    default public ActivityMetadataExport exportTo(CDOSession cdoSession, Instant to, boolean exportChanges, boolean computeImpactedRepresentations) {
        Objects.requireNonNull(cdoSession);
        Objects.requireNonNull(to);
        Instant from = new Date(cdoSession.getCommitInfoManager().getRepository().getCreationTime()).toInstant();
        return this.export(cdoSession, from, to, exportChanges, computeImpactedRepresentations);
    }

    public static Instant getSafeInstant(Instant instant, Instant repoCreation, Instant lastCommit) {
        Instant safeInstant = Instant.EPOCH.equals(instant) ? lastCommit : (lastCommit.isAfter(instant) ? (instant.isBefore(repoCreation) ? repoCreation : instant) : lastCommit);
        return safeInstant;
    }

    public static Instant getHeadInstant(CDOCommitInfoManager commitInfoManager, CDOBranch branch) {
        Instant lastCommit = new Date(commitInfoManager.getLastCommitOfBranch(branch, true)).toInstant();
        return lastCommit;
    }

    public static Instant parseDateTime(String argument) {
        Instant instant = null;
        if ("HEAD".equalsIgnoreCase(argument) || "0".equalsIgnoreCase(argument)) {
            instant = Instant.EPOCH;
        } else {
            try {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(argument, ZONED_DATE_FORMAT);
                instant = zonedDateTime.toInstant();
            }
            catch (DateTimeParseException e) {
                try {
                    LocalDateTime ldt = LocalDateTime.parse(argument, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                    ZoneOffset offset = ZoneOffset.systemDefault().getRules().getOffset(ldt);
                    instant = ldt.toInstant(offset);
                }
                catch (DateTimeParseException f) {
                    try {
                        instant = Instant.ofEpochMilli(Long.parseLong(argument));
                    }
                    catch (NumberFormatException | DateTimeException g) {
                        throw new IllegalStateException("Unable to get the commit date from the " + argument + " argument. Accepted format: \"yyyy-MM-dd'T'HH:mm:ss.SSSZ\", local time in ISO format \"yyyy-MM-dd'T'HH:mm:ss\" or time in ms since epoch");
                    }
                }
            }
        }
        return instant;
    }
}

