/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;

public class CDOFetchRuleManagerThreadLocal
implements CDOFetchRuleManager {
    private static final ThreadLocal<CDOFetchRuleManager> threadLocal = new ThreadLocal();

    public static CDOFetchRuleManager getCurrent() {
        return threadLocal.get();
    }

    public static void join(CDOFetchRuleManager fetchRulemanager) {
        threadLocal.set(fetchRulemanager);
    }

    public static void leave() {
        threadLocal.set(null);
    }

    @Override
    public CDOID getContext() {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getContext() : null;
    }

    @Override
    public List<CDOFetchRule> getFetchRules(Collection<CDOID> ids) {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getFetchRules(ids) : null;
    }

    @Override
    public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
        CDOFetchRuleManager analyzer = CDOFetchRuleManagerThreadLocal.getCurrent();
        return analyzer != null ? analyzer.getCollectionLoadingPolicy() : null;
    }
}

