/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.NewSharedModelingProject;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.UserUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager.CollabFileUserManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.spi.server.InternalRepository;

public abstract class AbstractRepositoryManager
implements IRepositoryManager {
    @Override
    public IStatus preStart(RepositoryData repositoryData) {
        this.logTask("Pre-start", repositoryData);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus postStart(RepositoryData repositoryData) {
        this.logTask("Post-start", repositoryData);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus preStop(RepositoryData repositoryData) {
        this.logTask("Pre-stop", repositoryData);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus postStop(RepositoryData repositoryData) {
        this.logTask("Post-stop", repositoryData);
        return Status.OK_STATUS;
    }

    protected void logTask(String taskName, RepositoryData repositoryData) {
        String key;
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty(taskName)) {
            sb.append(taskName);
            sb.append(": ");
        }
        if (repositoryData != null && !StringUtil.isEmpty(repositoryData.getRepositoryName())) {
            sb.append(repositoryData.getRepositoryName());
        }
        if (!StringUtil.isEmpty(key = this.getKey())) {
            sb.append(" - ").append(key);
        }
        OM.LOG.info(sb.toString());
    }

    @Override
    public List<SimpleUser> getAllUsers(String repositoryName) {
        Optional<InternalRepository> repository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        if (repository.isPresent()) {
            Stream<Object> users = Stream.empty();
            Optional<CollabFileUserManager> collabFileUserManager = repository.map(InternalRepository::getSessionManager).map(ISessionManager::getAuthenticator).filter(CollabFileUserManager.class::isInstance).map(CollabFileUserManager.class::cast);
            users = collabFileUserManager.isPresent() ? collabFileUserManager.get().getUserIds().stream().map(userId -> {
                SimpleUser simpleUser = new SimpleUser();
                simpleUser.setId((String)userId);
                return simpleUser;
            }) : repository.map(SecurityManagerUtil::getSecurityManager).map(ISecurityManager::getRealm).map(Realm::getAllUsers).map(Stream::of).orElseGet(Stream::empty).flatMap(Collection::stream).map(UserUtil::mapToSimpleUser);
            return users.toList();
        }
        return Collections.emptyList();
    }

    @Override
    public IStatus createUser(String repositoryName, NewUser newUser) {
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository manager has been found for the repository %1$s.", repositoryName));
    }

    @Override
    public IStatus deleteUser(String repositoryName, String username) {
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository manager has been found for the repository %1$s.", repositoryName));
    }

    @Override
    public Optional<IRepository> prepareRepositoryForImport(RepositoryData repositoryData) {
        return Optional.empty();
    }

    @Override
    public IStatus postSharedModelingProjectCreation(NewSharedModelingProject project) {
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", "The data are invalid.");
    }

    @Override
    public boolean canHandleAuthenticationType(IRepository repository) {
        return false;
    }
}

